/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.abstractions.sources;

import com.zeitheron.hammercore.internal.init.RegistriesHL;
import com.zeitheron.hammercore.utils.base.Cast;
import java.io.IOException;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.zeith.hammerlib.abstractions.sources.EntitySourceType;
import org.zeith.hammerlib.abstractions.sources.IObjectSourceType;
import org.zeith.hammerlib.abstractions.sources.TileSourceType;

public interface IObjectSource<T> {
    public NBTTagCompound writeSource();

    public IObjectSourceType getType();

    public Class<T> getBaseType();

    public T get(World var1);

    default public <R> Optional<R> get(Class<R> base, World level) {
        return Cast.optionally(this.get(level), base);
    }

    public static Supplier<EntitySourceType.EntitySource> ofEntity(@Nonnull Entity entity) {
        return () -> new EntitySourceType.EntitySource(entity.func_145782_y());
    }

    public static Supplier<TileSourceType.TileSource> ofTile(@Nonnull TileEntity tile) {
        return () -> new TileSourceType.TileSource(tile.func_174877_v());
    }

    public static NBTTagCompound writeSource(IObjectSource<?> src) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74782_a("Src", (NBTBase)src.writeSource());
        tag.func_74778_a("Type", src.getType().getRegistryKey().toString());
        return tag;
    }

    public static Optional<IObjectSource<?>> readSource(@Nullable NBTTagCompound tag) {
        if (tag == null) {
            return Optional.empty();
        }
        IObjectSourceType type = (IObjectSourceType)RegistriesHL.OBJECT_SOURCE().getValue(new ResourceLocation(tag.func_74779_i("Type")));
        if (type == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(type.readSource(tag.func_74775_l("Src")));
    }

    public static void writeSource(@Nullable IObjectSource<?> src, @Nonnull PacketBuffer buf) {
        buf.writeBoolean(src != null);
        if (src == null) {
            return;
        }
        buf.func_192572_a(src.getType().getRegistryKey());
        buf.func_150786_a(src.writeSource());
    }

    public static Optional<IObjectSource<?>> readSource(@Nonnull PacketBuffer buf) throws IOException {
        if (!buf.readBoolean()) {
            return Optional.empty();
        }
        IObjectSourceType type = (IObjectSourceType)RegistriesHL.OBJECT_SOURCE().getValue(buf.func_192575_l());
        NBTTagCompound src = buf.func_150793_b();
        if (type == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(type.readSource(src));
    }
}

