/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.utils;

import com.zeitheron.hammercore.HammerCore;
import com.zeitheron.hammercore.utils.WorldLocation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketCustomSound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class SoundObject {
    public ResourceLocation name;
    public SoundEvent sound;

    public SoundObject(ResourceLocation name) {
        this.name = name;
    }

    public SoundObject(String modid, String path) {
        this(new ResourceLocation(modid, path));
    }

    public Targeted targeted(EntityPlayerMP towards) {
        return new Targeted(towards);
    }

    public void playAt(WorldLocation location, float volume, float pitch, SoundCategory category) {
        HammerCore.audioProxy.playSoundAt(location.getWorld(), this.name.toString(), location.getPos(), volume, pitch, category);
    }

    public void playAsPlayer(Entity player, float volume, float pitch) {
        HammerCore.audioProxy.playSoundAt(player.field_70170_p, this.name.toString(), player.field_70165_t, player.field_70163_u, player.field_70161_v, volume, pitch, SoundCategory.PLAYERS);
    }

    public void playAsMob(Entity ent, float volume, float pitch) {
        HammerCore.audioProxy.playSoundAt(ent.field_70170_p, this.name.toString(), ent.field_70165_t, ent.field_70163_u, ent.field_70161_v, volume, pitch, ent instanceof IMob ? SoundCategory.HOSTILE : SoundCategory.NEUTRAL);
    }

    public void playAsBlock(World world, BlockPos pos, float volume, float pitch) {
        this.play(world, pos, volume, pitch, SoundCategory.BLOCKS);
    }

    public void play(World world, BlockPos pos, float volume, float pitch, SoundCategory category) {
        HammerCore.audioProxy.playSoundAt(world, this.name.toString(), pos, volume, pitch, category);
    }

    public void play(World world, Vec3d pos, float volume, float pitch, SoundCategory category) {
        HammerCore.audioProxy.playSoundAt(world, this.name.toString(), pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, volume, pitch, category);
    }

    public class Targeted {
        protected final EntityPlayerMP target;

        public Targeted(EntityPlayerMP target) {
            this.target = target;
        }

        public void playAsPlayer(Entity player, float volume, float pitch) {
            this.target.field_71135_a.func_147359_a((Packet)new SPacketCustomSound(SoundObject.this.name.toString(), SoundCategory.PLAYERS, player.field_70165_t, player.field_70163_u, player.field_70161_v, volume, pitch));
        }

        public void playAsMob(Entity ent, float volume, float pitch) {
            this.target.field_71135_a.func_147359_a((Packet)new SPacketCustomSound(SoundObject.this.name.toString(), ent instanceof IMob ? SoundCategory.HOSTILE : SoundCategory.NEUTRAL, ent.field_70165_t, ent.field_70163_u, ent.field_70161_v, volume, pitch));
        }

        public void playAsBlock(BlockPos pos, float volume, float pitch) {
            this.play(pos, volume, pitch, SoundCategory.BLOCKS);
        }

        public void play(BlockPos pos, float volume, float pitch, SoundCategory category) {
            this.target.field_71135_a.func_147359_a((Packet)new SPacketCustomSound(SoundObject.this.name.toString(), category, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, volume, pitch));
        }

        public void play(Vec3d pos, float volume, float pitch, SoundCategory category) {
            this.target.field_71135_a.func_147359_a((Packet)new SPacketCustomSound(SoundObject.this.name.toString(), category, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, volume, pitch));
        }
    }
}

