/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.utils;

import com.google.common.collect.Lists;
import com.zeitheron.hammercore.HammerCore;
import com.zeitheron.hammercore.utils.base.Cast;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ReflectionUtil {
    private static Field modifiersField;
    private static Object reflectionFactory;
    private static Method newFieldAccessor;
    private static Method fieldAccessorSet;

    public static Type[] getTypeArgs(Type type) {
        if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            return pt.getActualTypeArguments();
        }
        return new Type[0];
    }

    public static Class<?> fetchClassAny(org.objectweb.asm.Type type) {
        return ReflectionUtil.fetchClass(type.getSort() < 9 ? type.getClassName() : type.getInternalName().replace('/', '.'));
    }

    public static <T> Class<T> fetchClass(org.objectweb.asm.Type type) {
        return ReflectionUtil.fetchClass(type.getSort() < 9 ? type.getClassName() : type.getInternalName().replace('/', '.'));
    }

    public static <T> Class<T> fetchClass(String name) {
        block3: {
            try {
                return (Class)Cast.cast(Class.forName(name));
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (RuntimeException e) {
                if (!e.getMessage().contains("invalid dist")) break block3;
                HammerCore.LOG.warn("Attempted to load class from invalid dist: " + name, (Throwable)e);
            }
        }
        return null;
    }

    public static Iterable<Field> getFieldsUpTo(@Nonnull Class<?> startClass, @Nullable Class<?> exclusiveParent) {
        ArrayList currentClassFields = Lists.newArrayList((Object[])startClass.getDeclaredFields());
        Class<?> parentClass = startClass.getSuperclass();
        if (!(parentClass == null || exclusiveParent != null && parentClass.equals(exclusiveParent))) {
            List parentClassFields = (List)ReflectionUtil.getFieldsUpTo(parentClass, exclusiveParent);
            currentClassFields.addAll(parentClassFields);
        }
        return currentClassFields;
    }

    public static boolean setStaticFinalField(Class<?> cls, String var, Object val) {
        try {
            return ReflectionUtil.setStaticFinalField(cls.getDeclaredField(var), val);
        }
        catch (Throwable err) {
            err.printStackTrace();
            return false;
        }
    }

    public static boolean setStaticFinalField(Field f, Object val) {
        try {
            if (Modifier.isStatic(f.getModifiers())) {
                return ReflectionUtil.setFinalField(f, null, val);
            }
            return false;
        }
        catch (Throwable err) {
            err.printStackTrace();
            return false;
        }
    }

    public static boolean setFinalField(Field f, @Nullable Object instance, Object thing) throws ReflectiveOperationException {
        if (f == null) {
            return false;
        }
        if (Modifier.isFinal(f.getModifiers())) {
            ReflectionUtil.makeWritable(f);
            Object fieldAccessor = newFieldAccessor.invoke(reflectionFactory, f, false);
            fieldAccessorSet.invoke(fieldAccessor, instance, thing);
            return true;
        }
        f.set(instance, thing);
        return true;
    }

    private static Field makeWritable(Field f) throws ReflectiveOperationException {
        f.setAccessible(true);
        if (modifiersField == null) {
            Method getReflectionFactory = Class.forName("sun.reflect.ReflectionFactory").getDeclaredMethod("getReflectionFactory", new Class[0]);
            reflectionFactory = getReflectionFactory.invoke(null, new Object[0]);
            newFieldAccessor = Class.forName("sun.reflect.ReflectionFactory").getDeclaredMethod("newFieldAccessor", Field.class, Boolean.TYPE);
            fieldAccessorSet = Class.forName("sun.reflect.FieldAccessor").getDeclaredMethod("set", Object.class, Object.class);
            modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
        }
        modifiersField.setInt(f, f.getModifiers() & 0xFFFFFFEF);
        return f;
    }

    public static Object getValue(Object object, Class<?> type) {
        Field field = ReflectionUtil.getField(object.getClass(), type);
        if (field == null) {
            return null;
        }
        try {
            return field.get(object);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Object getValue(Class<?> object, String fieldName) {
        Field field = ReflectionUtil.getField(object, fieldName);
        if (field == null || !Modifier.isStatic(field.getModifiers())) {
            return null;
        }
        try {
            return field.get(null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Field getField(Class<?> clazz, Class<?> type) {
        Field ret = null;
        for (Field field : clazz.getDeclaredFields()) {
            if (!type.isAssignableFrom(field.getType())) continue;
            if (ret != null) {
                return null;
            }
            field.setAccessible(true);
            ret = field;
        }
        return ret;
    }

    public static Field getFieldByValue(Class<?> clazz, Object instance, Object value) {
        for (Field field : clazz.getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers()) || !field.getType().isAssignableFrom(value.getClass())) continue;
            field.setAccessible(true);
            try {
                if (field.get(instance) != value) continue;
                return field;
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
        }
        return null;
    }

    public static Field getField(Class<?> clazz, String name) {
        Field ret = null;
        for (Field field : clazz.getDeclaredFields()) {
            if (!name.equals(field.getName())) continue;
            if (ret != null) {
                return null;
            }
            field.setAccessible(true);
            ret = field;
        }
        return ret;
    }

    public static Class<?> getCaller() {
        try {
            return Class.forName(Thread.currentThread().getStackTrace()[1].getClassName());
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }
}

