/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.net.internal;

import com.zeitheron.hammercore.net.IPacket;
import com.zeitheron.hammercore.net.MainThreaded;
import com.zeitheron.hammercore.net.PacketContext;
import com.zeitheron.hammercore.tile.TileSyncable;
import com.zeitheron.hammercore.utils.base.Cast;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

@MainThreaded
public class PacketSyncSyncableTile
implements IPacket {
    private BlockPos pos;
    private NBTTagCompound nbt;
    private String clazz;

    public PacketSyncSyncableTile() {
    }

    public PacketSyncSyncableTile(TileSyncable tile) {
        this.nbt = tile.func_189517_E_();
        this.pos = tile.func_174877_v().func_185334_h();
        this.clazz = tile.getClass().getName();
    }

    @Override
    public void write(PacketBuffer buf) {
        buf.func_150786_a(this.nbt);
        buf.func_179255_a(this.pos);
    }

    @Override
    public void read(PacketBuffer buf) throws IOException {
        this.nbt = buf.func_150793_b();
        this.pos = buf.func_179259_c();
    }

    @Override
    public void executeOnClient2(PacketContext net) {
        World world = net.getPlayer().field_70170_p;
        if (world != null && world.func_175707_a(this.pos, this.pos)) {
            TileSyncable sync = Cast.cast(world.func_175625_s(this.pos), TileSyncable.class);
            if (sync == null) {
                try {
                    sync = (TileSyncable)Class.forName(this.clazz).newInstance();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (sync != null) {
                sync.onPreSync(this.nbt);
                sync.handleUpdateTag(this.nbt);
                sync.onSynced();
            }
        }
    }

    @Override
    public void executeOnServer2(PacketContext net) {
        EntityPlayer player = net.getPlayer();
        if (player == null) {
            return;
        }
        TileEntity te = player.field_70170_p.func_175625_s(this.pos);
        if (te instanceof TileSyncable) {
            net.withReply(new PacketSyncSyncableTile((TileSyncable)te));
        }
    }

    static {
        IPacket.handle(PacketSyncSyncableTile.class, PacketSyncSyncableTile::new);
    }
}

