/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.net.internal;

import com.zeitheron.hammercore.net.IPacket;
import com.zeitheron.hammercore.net.MainThreaded;
import com.zeitheron.hammercore.net.PacketContext;
import java.io.IOException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

@MainThreaded
public class PacketSyncAnyTile
implements IPacket {
    private BlockPos pos;
    private NBTTagCompound nbt;
    private String clazz;

    public PacketSyncAnyTile() {
    }

    public PacketSyncAnyTile(TileEntity tile) {
        this.nbt = tile.func_189517_E_();
        this.pos = tile.func_174877_v().func_185334_h();
        this.clazz = tile.getClass().getName();
    }

    @Override
    public void write(PacketBuffer buf) {
        buf.func_150786_a(this.nbt);
        buf.func_179255_a(this.pos);
    }

    @Override
    public void read(PacketBuffer buf) throws IOException {
        this.nbt = buf.func_150793_b();
        this.pos = buf.func_179259_c();
    }

    @Override
    public void executeOnClient2(PacketContext net) {
        World world = net.getPlayer().field_70170_p;
        if (world != null && world.func_175707_a(this.pos, this.pos)) {
            TileEntity tile = world.func_175625_s(this.pos);
            if (tile == null) {
                try {
                    tile = (TileEntity)Class.forName(this.clazz).newInstance();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (tile != null) {
                tile.handleUpdateTag(this.nbt);
            }
        }
    }

    static {
        IPacket.handle(PacketSyncAnyTile.class, PacketSyncAnyTile::new);
    }
}

