/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.net;

import com.zeitheron.hammercore.HammerCore;
import com.zeitheron.hammercore.net.IPacket;
import com.zeitheron.hammercore.net.PacketContext;
import com.zeitheron.hammercore.utils.base.Cast;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PacketHolder {
    public final IPacket packet;

    public PacketHolder(IPacket packet) {
        this.packet = packet;
    }

    public boolean executeOnMainThread() {
        return this.packet != null && this.packet.executeOnMainThread();
    }

    @Nullable
    @SideOnly(value=Side.CLIENT)
    public PacketHolder execute(FMLNetworkEvent.ClientCustomPacketEvent handler) {
        EntityPlayer player = HammerCore.renderProxy.getClientPlayer();
        PacketContext ctx = new PacketContext(new PacketContext.ContextSenderServer(player), this, null);
        this.packet.executeOnClient2(ctx);
        return new PacketHolder(ctx.getReply());
    }

    @Nullable
    public PacketHolder execute(FMLNetworkEvent.ServerCustomPacketEvent handler) {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (this.packet == null) {
            HammerCore.LOG.warn("Failed to process packet that failed to decode.");
            return null;
        }
        NetHandlerPlayServer net = Cast.cast(handler.getHandler(), NetHandlerPlayServer.class);
        if (net == null) {
            HammerCore.LOG.warn("Failed to process packet " + this.packet + " on server side due to missing player in the connection.");
            return null;
        }
        EntityPlayerMP mp = net.field_147369_b;
        PacketContext ctx = new PacketContext(new PacketContext.ContextSenderPlayerMP(mp), this, server);
        this.packet.executeOnServer2(ctx);
        return new PacketHolder(ctx.getReply());
    }
}

