/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.internal.ap;

import com.zeitheron.hammercore.internal.ap.IAPContext;
import com.zeitheron.hammercore.internal.ap.IAnnotationProcessor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AnnotationProcessorRegistry {
    private static final Map<Class<? extends Annotation>, List<IAnnotationProcessor<?>>> AP = new HashMap();

    public static <T extends Annotation> void register(Class<T> annotation, IAnnotationProcessor<T> ap) {
        AP.computeIfAbsent(annotation, v -> new ArrayList()).add(ap);
    }

    public static void scan(IAPContext ctx, Field f, Object value) {
        if (AP.isEmpty()) {
            return;
        }
        for (Annotation annotation : f.getDeclaredAnnotations()) {
            List<IAnnotationProcessor<?>> aps = AP.get(annotation.annotationType());
            if (aps == null) continue;
            for (IAnnotationProcessor<?> ap : aps) {
                ap.onScanned(ctx, annotation, f, value);
            }
        }
    }

    public static void scanReg(IAPContext ctx, Field f, Object value, boolean postReg) {
        if (AP.isEmpty()) {
            return;
        }
        for (Annotation annotation : f.getDeclaredAnnotations()) {
            List<IAnnotationProcessor<?>> aps = AP.get(annotation.annotationType());
            if (aps == null) continue;
            for (IAnnotationProcessor<?> ap : aps) {
                if (postReg) {
                    ap.onPostRegistered(ctx, annotation, f, value);
                    continue;
                }
                ap.onPreRegistered(ctx, annotation, f, value);
            }
        }
    }

    public static void scan(IAPContext ctx, Method m) {
        if (AP.isEmpty()) {
            return;
        }
        for (Annotation annotation : m.getDeclaredAnnotations()) {
            List<IAnnotationProcessor<?>> aps = AP.get(annotation.annotationType());
            if (aps == null) continue;
            for (IAnnotationProcessor<?> ap : aps) {
                ap.onScanned(ctx, annotation, m);
            }
        }
    }
}

