/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.event.vanilla;

import com.zeitheron.hammercore.event.WrenchEvent;
import com.zeitheron.hammercore.internal.blocks.IWitherProofBlock;
import com.zeitheron.hammercore.net.HCNet;
import com.zeitheron.hammercore.tile.ITileDroppable;
import com.zeitheron.hammercore.tile.IVoxelShapeTile;
import com.zeitheron.hammercore.tile.TileSyncable;
import com.zeitheron.hammercore.utils.AABBUtils;
import com.zeitheron.hammercore.utils.WorldLocation;
import com.zeitheron.hammercore.utils.base.Cast;
import com.zeitheron.hammercore.utils.wrench.IWrenchItem;
import com.zeitheron.hammercore.utils.wrench.IWrenchable;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.Explosion;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDestroyBlockEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber
public class TileHandler {
    @SubscribeEvent
    public static void breakBlock(BlockEvent.BreakEvent evt) {
        TileEntity te;
        IBlockState state = evt.getState();
        if (state.func_177230_c() instanceof ITileDroppable) {
            ((ITileDroppable)state.func_177230_c()).createDrop(evt.getPlayer(), evt.getWorld(), evt.getPos());
        }
        if ((te = evt.getWorld().func_175625_s(evt.getPos())) instanceof ITileDroppable) {
            ((ITileDroppable)te).createDrop(evt.getPlayer(), evt.getWorld(), evt.getPos());
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void playerInteract(PlayerInteractEvent.RightClickBlock evt) {
        IWrenchItem item;
        EntityPlayer player = evt.getEntityPlayer();
        if (player != null && !player.func_184586_b(evt.getHand()).func_190926_b() && (item = Cast.cast(player.func_184586_b(evt.getHand()).func_77973_b(), IWrenchItem.class)) != null && item.canWrench(player.func_184586_b(evt.getHand()))) {
            MinecraftForge.EVENT_BUS.post((Event)new WrenchEvent(player, evt.getPos(), evt.getHand(), evt.getFace()));
            item.onWrenchUsed(player, evt.getPos(), evt.getHand());
            WorldLocation wl = new WorldLocation(evt.getWorld(), evt.getPos());
            boolean swing = false;
            if (wl.getBlock() instanceof IWrenchable && ((IWrenchable)wl.getBlock()).onWrenchUsed(wl, player, evt.getHand())) {
                swing = true;
            }
            if (wl.getTile() instanceof IWrenchable && ((IWrenchable)wl.getTile()).onWrenchUsed(wl, player, evt.getHand())) {
                swing = true;
            }
            if (swing) {
                HCNet.swingArm(player, evt.getHand());
                evt.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void placeBlock(BlockEvent.PlaceEvent evt) {
        Block block;
        TileEntity te = evt.getWorld().func_175625_s(evt.getPos());
        if (te == null && (block = evt.getPlacedBlock().func_177230_c()) instanceof ITileEntityProvider) {
            te = block.createTileEntity(evt.getWorld(), evt.getPlacedBlock());
            evt.getWorld().func_175690_a(evt.getPos(), te);
        }
        if (te instanceof TileSyncable) {
            TileSyncable tile = (TileSyncable)te;
            tile.onPlacedBy(evt.getPlayer(), evt.getHand());
        }
    }

    @SubscribeEvent
    public static void handleWitherBlocks(LivingDestroyBlockEvent e) {
        IBlockState state;
        if (e.getEntityLiving() instanceof EntityWither && (state = e.getState()).func_177230_c() instanceof IWitherProofBlock && ((IWitherProofBlock)state.func_177230_c()).isWitherproof(state)) {
            e.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void handleWitherBlocks(ExplosionEvent.Detonate w) {
        Explosion expl = w.getExplosion();
        if (expl != null && expl.func_94613_c() instanceof EntityWither) {
            List b = w.getAffectedBlocks();
            for (int i = 0; i < b.size(); ++i) {
                BlockPos p = (BlockPos)b.get(i);
                IBlockState state = w.getWorld().func_180495_p(p);
                if (!(state.func_177230_c() instanceof IWitherProofBlock) || !((IWitherProofBlock)state.func_177230_c()).isWitherproof(state)) continue;
                b.remove(i);
                --i;
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void overrideBlockHiglight(DrawBlockHighlightEvent e) {
        RayTraceResult rtr = e.getTarget();
        if (rtr != null && rtr.field_72313_a == RayTraceResult.Type.BLOCK) {
            float partialTicks = e.getPartialTicks();
            EntityPlayer player = e.getPlayer();
            TileEntity tile = player.field_70170_p.func_175625_s(rtr.func_178782_a());
            if (tile instanceof IVoxelShapeTile) {
                IVoxelShapeTile lineHighlight = (IVoxelShapeTile)tile;
                e.setCanceled(true);
                GlStateManager.func_179147_l();
                GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                GlStateManager.func_187441_d((float)2.0f);
                GlStateManager.func_179090_x();
                GlStateManager.func_179132_a((boolean)false);
                BlockPos blockpos = rtr.func_178782_a();
                IBlockState iblockstate = player.field_70170_p.func_180495_p(blockpos);
                if (iblockstate.func_185904_a() != Material.field_151579_a && player.field_70170_p.func_175723_af().func_177746_a(blockpos)) {
                    double d3 = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)partialTicks;
                    double d4 = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)partialTicks;
                    double d5 = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)partialTicks;
                    AABBUtils.Line.LineRenderer.drawBoundingBox(lineHighlight.getHighlightedLines().grow(0.002f).offset((double)blockpos.func_177958_n() - d3, (double)blockpos.func_177956_o() - d4, (double)blockpos.func_177952_p() - d5).asLines().stream(), 0.0f, 0.0f, 0.0f, 0.4f);
                }
                GlStateManager.func_179132_a((boolean)true);
                GlStateManager.func_179098_w();
                GlStateManager.func_179084_k();
            }
        }
    }
}

