/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore;

import com.zeitheron.hammercore.api.lighting.ColoredLightManager;
import com.zeitheron.hammercore.client.HCClientOptions;
import com.zeitheron.hammercore.net.HCNet;
import com.zeitheron.hammercore.net.internal.opts.PacketCHCOpts;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.relauncher.Side;

public class ServerHCClientPlayerData {
    public static final EnumMap<Side, ServerHCClientPlayerData> DATAS = new EnumMap(Side.class);
    public final Side side;
    public Map<String, HCClientOptions> playerMap = new HashMap<String, HCClientOptions>();

    private ServerHCClientPlayerData(Side s) {
        this.side = s;
    }

    public static HCClientOptions getOptionsFor(EntityPlayer player) {
        return DATAS.get(player.field_70170_p.field_72995_K ? Side.CLIENT : Side.SERVER).getOptionsForPlayer(player);
    }

    public void assign(String player, HCClientOptions opts) {
        this.playerMap.put(player, opts);
    }

    public HCClientOptions opts(String player) {
        HCClientOptions hc = this.playerMap.get(player);
        if (hc == null) {
            hc = new HCClientOptions();
            this.playerMap.put(player, hc);
        }
        if (hc.def && this.side == Side.CLIENT) {
            hc.def = false;
            HCNet.INSTANCE.sendToServer(new PacketCHCOpts().setLPlayer(player));
        }
        return hc;
    }

    public HCClientOptions getOptionsForPlayer(EntityPlayer player) {
        if (player.field_70170_p.field_72995_K && player == ColoredLightManager.getClientPlayer()) {
            return HCClientOptions.options;
        }
        return this.opts(player.func_146103_bH().getId().toString());
    }

    static {
        DATAS.put(Side.SERVER, new ServerHCClientPlayerData(Side.SERVER));
        DATAS.put(Side.CLIENT, new ServerHCClientPlayerData(Side.CLIENT));
    }
}

