/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore;

import com.zeitheron.hammercore.api.mhb.BlockTraceable;
import com.zeitheron.hammercore.api.mhb.ICubeManager;
import com.zeitheron.hammercore.api.mhb.IRayCubeGetter;
import com.zeitheron.hammercore.api.mhb.IRayCubeRegistry;
import com.zeitheron.hammercore.utils.base.Cast;
import com.zeitheron.hammercore.utils.math.vec.Cuboid6;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public final class RayCubeRegistry
implements IRayCubeRegistry,
IRayCubeGetter {
    public static final RayCubeRegistry instance = new RayCubeRegistry();
    final Map<Block, Cuboid6[]> cubes = new HashMap<Block, Cuboid6[]>();
    final Map<Block, ICubeManager> mgrs = new HashMap<Block, ICubeManager>();

    private RayCubeRegistry() {
        IRayCubeGetter.Instance.getter = this;
    }

    @Override
    public void bindBlockCube6(BlockTraceable target, Cuboid6 ... boxes) {
        this.cubes.put(target, boxes);
    }

    @Override
    public Cuboid6[] getBoundCubes6(BlockTraceable target) {
        return this.mgrs.get((Object)target) == null ? (this.cubes.get((Object)target) != null ? this.cubes.get((Object)target) : new Cuboid6[]{}) : null;
    }

    @Override
    public void bindBlockCubeManager(BlockTraceable target, ICubeManager manager) {
        this.mgrs.put(target, manager);
    }

    @Override
    public ICubeManager getBoundCubeManager(BlockTraceable target) {
        return this.mgrs.get((Object)target);
    }

    public static Cuboid6[] getCuboidsAt(World world, BlockPos pos) {
        BlockTraceable bt = Cast.cast(world.func_180495_p(pos).func_177230_c(), BlockTraceable.class);
        if (bt != null) {
            ICubeManager mgr = instance.getBoundCubeManager(bt);
            if (mgr != null) {
                return mgr.getCuboids(world, pos, world.func_180495_p(pos));
            }
            Cuboid6[] cbs = instance.getBoundCubes6(bt);
            if (cbs != null) {
                return cbs;
            }
        }
        return new Cuboid6[]{new Cuboid6(world.func_180495_p(pos).func_185900_c((IBlockAccess)world, pos))};
    }
}

