/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.ingredients;

import java.util.Collection;
import java.util.Comparator;
import javax.annotation.Nullable;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRegistry;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.recipe.IIngredientType;
import mezz.jei.config.Config;
import mezz.jei.gui.ingredients.IIngredientListElement;
import mezz.jei.ingredients.IngredientListElement;
import mezz.jei.ingredients.IngredientListElementComparator;
import mezz.jei.ingredients.IngredientOrderTracker;
import mezz.jei.startup.IModIdHelper;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.common.ProgressManager;

public final class IngredientListElementFactory {
    private static final IngredientOrderTracker ORDER_TRACKER = new IngredientOrderTracker();

    private IngredientListElementFactory() {
    }

    public static NonNullList<IIngredientListElement> createBaseList(IIngredientRegistry ingredientRegistry, IModIdHelper modIdHelper) {
        NonNullList ingredientListElements = NonNullList.func_191196_a();
        for (IIngredientType ingredientType : ingredientRegistry.getRegisteredIngredientTypes()) {
            IngredientListElementFactory.addToBaseList((NonNullList<IIngredientListElement>)ingredientListElements, ingredientRegistry, ingredientType, modIdHelper);
        }
        ingredientListElements.sort((Comparator)IngredientListElementComparator.INSTANCE);
        return ingredientListElements;
    }

    public static <V> NonNullList<IIngredientListElement<V>> createList(IIngredientRegistry ingredientRegistry, IIngredientType<V> ingredientType, Collection<V> ingredients, IModIdHelper modIdHelper) {
        IIngredientHelper<V> ingredientHelper = ingredientRegistry.getIngredientHelper(ingredientType);
        IIngredientRenderer<V> ingredientRenderer = ingredientRegistry.getIngredientRenderer(ingredientType);
        NonNullList list = NonNullList.func_191196_a();
        for (V ingredient : ingredients) {
            int orderIndex;
            IngredientListElement<V> ingredientListElement;
            if (ingredient == null || (ingredientListElement = IngredientListElement.create(ingredient, ingredientHelper, ingredientRenderer, modIdHelper, orderIndex = ORDER_TRACKER.getOrderIndex(ingredient, ingredientHelper))) == null) continue;
            list.add(ingredientListElement);
        }
        return list;
    }

    @Nullable
    public static <V> IIngredientListElement<V> createUnorderedElement(IIngredientRegistry ingredientRegistry, IIngredientType<V> ingredientType, V ingredient, IModIdHelper modIdHelper) {
        IIngredientHelper<V> ingredientHelper = ingredientRegistry.getIngredientHelper(ingredientType);
        IIngredientRenderer<V> ingredientRenderer = ingredientRegistry.getIngredientRenderer(ingredientType);
        return IngredientListElement.create(ingredient, ingredientHelper, ingredientRenderer, modIdHelper, 0);
    }

    private static <V> void addToBaseList(NonNullList<IIngredientListElement> baseList, IIngredientRegistry ingredientRegistry, IIngredientType<V> ingredientType, IModIdHelper modIdHelper) {
        IIngredientHelper<V> ingredientHelper = ingredientRegistry.getIngredientHelper(ingredientType);
        IIngredientRenderer<V> ingredientRenderer = ingredientRegistry.getIngredientRenderer(ingredientType);
        Collection<V> ingredients = ingredientRegistry.getAllIngredients(ingredientType);
        if (Config.skipShowingProgressBar()) {
            for (V ingredient : ingredients) {
                int orderIndex;
                IngredientListElement<V> ingredientListElement;
                if (ingredient == null || (ingredientListElement = IngredientListElement.create(ingredient, ingredientHelper, ingredientRenderer, modIdHelper, orderIndex = ORDER_TRACKER.getOrderIndex(ingredient, ingredientHelper))) == null) continue;
                baseList.add(ingredientListElement);
            }
        } else {
            ProgressManager.ProgressBar progressBar = ProgressManager.push((String)("Registering ingredients: " + ingredientType.getIngredientClass().getSimpleName()), (int)ingredients.size());
            for (V ingredient : ingredients) {
                int orderIndex;
                IngredientListElement<V> ingredientListElement;
                progressBar.step(ingredientHelper.getDisplayName(ingredient));
                if (ingredient == null || (ingredientListElement = IngredientListElement.create(ingredient, ingredientHelper, ingredientRenderer, modIdHelper, orderIndex = ORDER_TRACKER.getOrderIndex(ingredient, ingredientHelper))) == null) continue;
                baseList.add(ingredientListElement);
            }
            ProgressManager.pop((ProgressManager.ProgressBar)progressBar);
        }
    }
}

