/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.globe.common.block;

import javax.annotation.Nullable;
import me.ichun.mods.globe.common.Globe;
import me.ichun.mods.globe.common.tileentity.TileEntityGlobeStand;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockGlobeStand
extends Block
implements ITileEntityProvider {
    public static final AxisAlignedBB GLOBE_AABB = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 0.5, 0.75);
    public static final AxisAlignedBB STAND_AABB = new AxisAlignedBB(0.1875, 0.0, 0.1875, 0.8125, 0.125, 0.8125);
    public static final AxisAlignedBB STAND_AND_GLOBE_AABB = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 0.9, 0.75);

    public BlockGlobeStand() {
        super(Material.field_151573_f);
        this.func_149711_c(5.0f);
        this.func_149752_b(10.0f);
        this.setRegistryName(new ResourceLocation("globe", "globe_stand"));
        this.func_149663_c("globe.block.globeStand");
        this.func_149647_a(CreativeTabs.field_78031_c);
    }

    @Nullable
    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityGlobeStand(null, true);
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TileEntityGlobeStand) {
            TileEntityGlobeStand gs = (TileEntityGlobeStand)te;
            if (!gs.isStand) {
                return GLOBE_AABB;
            }
            if (gs.itemTag == null) {
                return STAND_AABB;
            }
            return STAND_AND_GLOBE_AABB;
        }
        return field_185505_j;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TileEntityGlobeStand) {
            TileEntityGlobeStand gs = (TileEntityGlobeStand)te;
            if (!gs.isStand) {
                return GLOBE_AABB;
            }
            if (gs.itemTag == null) {
                return STAND_AABB;
            }
            return STAND_AND_GLOBE_AABB;
        }
        return null;
    }

    public void func_180649_a(World world, BlockPos pos, EntityPlayer player) {
        if (player.field_71075_bZ.field_75098_d) {
            return;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityGlobeStand) {
            TileEntityGlobeStand gc = (TileEntityGlobeStand)te;
            if (gc.itemTag != null) {
                ItemStack is;
                ItemStack itemStack = is = gc.itemTag.func_82582_d() ? new ItemStack(Globe.itemGlobe, 1, 0) : new ItemStack(Globe.itemGlobe, 1, 1);
                if (!gc.itemTag.func_82582_d()) {
                    is.func_77982_d(gc.itemTag);
                }
                if (player.field_71071_by.func_70441_a(is)) {
                    gc.itemTag = null;
                    if (gc.isStand) {
                        IBlockState state = world.func_180495_p(pos);
                        world.func_184138_a(pos, state, state, 3);
                    } else {
                        world.func_175698_g(pos);
                    }
                }
            }
        }
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityGlobeStand) {
            TileEntityGlobeStand gs = (TileEntityGlobeStand)te;
            if (gs.isStand) {
                return 7;
            }
        }
        return 0;
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        this.func_176208_a(world, pos, state, player);
        boolean flag = world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), world.field_72995_K ? 11 : 3);
        world.func_175664_x(pos);
        return flag;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityGlobeStand) {
            TileEntityGlobeStand gs = (TileEntityGlobeStand)te;
            if (gs.itemTag != null) {
                Block block;
                gs.snowTime = 200;
                boolean flag = false;
                ItemStack is = playerIn.func_184586_b(hand);
                if (is.func_77973_b() instanceof ItemBlock && ((block = ((ItemBlock)is.func_77973_b()).func_179223_d()) == Blocks.field_150359_w || block == Blocks.field_150399_cn)) {
                    if (block == Blocks.field_150359_w) {
                        gs.itemTag.func_82580_o("glassType");
                    } else {
                        gs.itemTag.func_74768_a("glassType", is.func_77952_i());
                    }
                    world.func_184138_a(pos, state, state, 3);
                    flag = true;
                }
                if (gs.isStand) {
                    gs.bobAmp = (playerIn.field_70125_A < 0.0f ? -10.0f : 10.0f) + playerIn.field_70125_A / 10.0f;
                    float x = -MathHelper.func_76126_a((float)(playerIn.field_70177_z * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(playerIn.field_70125_A * ((float)Math.PI / 180)));
                    float y = -MathHelper.func_76126_a((float)(playerIn.field_70125_A * ((float)Math.PI / 180)));
                    float z = MathHelper.func_76134_b((float)(playerIn.field_70177_z * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(playerIn.field_70125_A * ((float)Math.PI / 180)));
                    float f = MathHelper.func_76129_c((float)(x * x + y * y + z * z));
                    x = x / f * 0.2f;
                    z = z / f * 0.2f;
                    gs.rubberbandX = x;
                    gs.rubberbandZ = z;
                    if (facing.func_176740_k() == EnumFacing.Axis.Z) {
                        float rot = (float)((double)hitX - 0.5) * (float)facing.func_82599_e() * 10.0f;
                        if (rot < 0.0f && gs.rotateFactor > 0.0f || rot > 0.0f && gs.rotateFactor < 0.0f) {
                            gs.rotateFactor *= 0.7f;
                        }
                        gs.rotateFactor += rot;
                    } else if (facing.func_176740_k() == EnumFacing.Axis.X) {
                        float rot = (float)((double)hitZ - 0.5) * (float)(-facing.func_82601_c()) * 10.0f;
                        if (rot < 0.0f && gs.rotateFactor > 0.0f || rot > 0.0f && gs.rotateFactor < 0.0f) {
                            gs.rotateFactor *= 0.7f;
                        }
                        gs.rotateFactor += rot;
                    }
                    if (Math.abs(gs.rotateFactor) > 30.0f) {
                        gs.rotateFactor = gs.rotateFactor < 0.0f ? -30.0f : 30.0f;
                    }
                    flag = true;
                }
                return true;
            }
        }
        return false;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityGlobeStand) {
            TileEntityGlobeStand gs = (TileEntityGlobeStand)te;
            if (gs.itemTag != null) {
                ItemStack is = new ItemStack(Globe.itemGlobe, 1, gs.itemTag.func_82582_d() ? 0 : 1);
                if (!gs.itemTag.func_82582_d()) {
                    is.func_77982_d(gs.itemTag);
                }
                return is;
            }
        }
        return this.func_185473_a(world, pos, state);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!this.func_176196_c(worldIn, pos)) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
        }
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityGlobeStand) {
            TileEntityGlobeStand gs = (TileEntityGlobeStand)te;
            if (gs.isStand) {
                drops.add((Object)new ItemStack(Globe.blockGlobeStand, 1));
            }
            if (gs.itemTag != null) {
                ItemStack is = new ItemStack(Globe.itemGlobe, 1, gs.itemTag.func_82582_d() ? 0 : 1);
                if (!gs.itemTag.func_82582_d()) {
                    is.func_77982_d(gs.itemTag);
                }
                drops.add((Object)is);
            }
        }
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        super.func_180663_b(worldIn, pos, state);
        worldIn.func_175713_t(pos);
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos.func_177977_b()).isSideSolid((IBlockAccess)worldIn, pos, EnumFacing.UP) || worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150426_aN || worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150359_w || worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150399_cn;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }
}

