/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.quest.task;

import com.feed_the_beast.ftblib.lib.config.ConfigGroup;
import com.feed_the_beast.ftblib.lib.config.ConfigTimer;
import com.feed_the_beast.ftblib.lib.config.ConfigValue;
import com.feed_the_beast.ftblib.lib.io.DataIn;
import com.feed_the_beast.ftblib.lib.io.DataOut;
import com.feed_the_beast.ftblib.lib.math.Ticks;
import com.feed_the_beast.ftbquests.client.ClientQuestFile;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.QuestData;
import com.feed_the_beast.ftbquests.quest.task.BooleanTaskData;
import com.feed_the_beast.ftbquests.quest.task.FTBQuestsTasks;
import com.feed_the_beast.ftbquests.quest.task.Task;
import com.feed_the_beast.ftbquests.quest.task.TaskData;
import com.feed_the_beast.ftbquests.quest.task.TaskType;
import com.feed_the_beast.ftbquests.util.RayMatcher;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ObservationTask
extends Task {
    public final RayMatcher matcher = new RayMatcher();
    public Ticks timer = Ticks.NO_TICKS;

    public ObservationTask(Quest quest) {
        super(quest);
    }

    @Override
    public TaskType getType() {
        return FTBQuestsTasks.OBSERVATION;
    }

    @Override
    public void writeData(NBTTagCompound nbt) {
        super.writeData(nbt);
        this.matcher.writeData(nbt);
        nbt.func_74772_a("timer", this.timer.ticks());
    }

    @Override
    public void readData(NBTTagCompound nbt) {
        super.readData(nbt);
        this.matcher.readData(nbt);
        this.timer = Ticks.get((long)nbt.func_74763_f("timer"));
    }

    @Override
    public void writeNetData(DataOut data) {
        super.writeNetData(data);
        this.matcher.writeNetData(data);
        data.writeVarLong(this.timer.ticks());
    }

    @Override
    public void readNetData(DataIn data) {
        super.readNetData(data);
        this.matcher.readNetData(data);
        this.timer = Ticks.get((long)data.readVarLong());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.addEnum("type", () -> this.matcher.type, v -> {
            this.matcher.type = v;
        }, RayMatcher.Type.NAME_MAP);
        config.addString("match", () -> this.matcher.match, v -> {
            this.matcher.match = v;
        }, "");
        config.addString("properties", this.matcher::getPropertyString, this.matcher::setPropertyString, "");
        config.add("timer", (ConfigValue)new ConfigTimer(this.timer){

            public Ticks getTimer() {
                return ObservationTask.this.timer;
            }

            public void setTimer(Ticks v) {
                ObservationTask.this.timer = v;
            }
        }, (ConfigValue)new ConfigTimer(Ticks.NO_TICKS));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onButtonClicked(boolean canClick) {
        if (ClientQuestFile.INSTANCE.canEdit()) {
            Minecraft mc = Minecraft.func_71410_x();
            RayMatcher.Data data = RayMatcher.Data.get((World)mc.field_71441_e, mc.field_71476_x);
            mc.field_71439_g.func_145747_a((ITextComponent)new TextComponentString(data.toString()));
        }
    }

    @Override
    public TaskData createData(QuestData data) {
        return new BooleanTaskData<ObservationTask>(this, data);
    }
}

