/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.block;

import com.feed_the_beast.ftbquests.FTBQuests;
import com.feed_the_beast.ftbquests.item.FTBQuestsItems;
import com.feed_the_beast.ftbquests.quest.QuestData;
import com.feed_the_beast.ftbquests.quest.QuestFile;
import com.feed_the_beast.ftbquests.quest.QuestObject;
import com.feed_the_beast.ftbquests.tile.TileQuestBarrier;
import com.google.common.base.Predicate;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockQuestBarrier
extends Block {
    public static final PropertyBool COMPLETED = PropertyBool.func_177716_a((String)"completed");
    private static final Predicate<Entity> PREDICATE = entity -> entity instanceof EntityPlayer && ((EntityPlayer)entity).field_71075_bZ.field_75098_d;

    public BlockQuestBarrier() {
        super(Material.field_175972_I, MapColor.field_151674_s);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)COMPLETED, (Comparable)Boolean.valueOf(false)));
        this.field_149785_s = true;
        this.func_149722_s();
        this.func_149752_b(6000000.0f);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{COMPLETED});
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    @Deprecated
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P();
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileQuestBarrier();
    }

    @Deprecated
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Deprecated
    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    @Deprecated
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    @Deprecated
    public float func_185485_f(IBlockState state) {
        return 1.0f;
    }

    public void func_180653_a(World world, BlockPos pos, IBlockState state, float chance, int fortune) {
    }

    public boolean canEntityDestroy(IBlockState state, IBlockAccess world, BlockPos pos, Entity entity) {
        return false;
    }

    @Deprecated
    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entity, boolean isActualState) {
        if (entity instanceof EntityPlayer) {
            QuestFile file;
            if (((EntityPlayer)entity).field_71075_bZ.field_75098_d) {
                return;
            }
            TileEntity tileEntity = world.func_175625_s(pos);
            if (tileEntity instanceof TileQuestBarrier && (file = FTBQuests.PROXY.getQuestFile(world)) != null) {
                QuestObject object = ((TileQuestBarrier)tileEntity).getObject(file);
                QuestData data = file.getData(entity);
                if (object != null && data != null && object.isComplete(data)) {
                    return;
                }
            }
        }
        super.func_185477_a(state, world, pos, entityBox, collidingBoxes, entity, isActualState);
    }

    @Nullable
    @Deprecated
    public RayTraceResult func_180636_a(IBlockState state, World worldIn, BlockPos pos, Vec3d start, Vec3d end) {
        EntityPlayer player = worldIn.func_190525_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 5.0, PREDICATE);
        if (player == null) {
            return null;
        }
        return this.func_185503_a(pos, start, end, state.func_185900_c((IBlockAccess)worldIn, pos));
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity tileEntity;
        if (player.func_184586_b(hand).func_77973_b() == FTBQuestsItems.BARRIER) {
            return false;
        }
        if (!world.field_72995_K && FTBQuests.canEdit(player) && (tileEntity = world.func_175625_s(pos)) instanceof TileQuestBarrier) {
            ((TileQuestBarrier)tileEntity).editConfig((EntityPlayerMP)player, true);
        }
        return true;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileQuestBarrier) {
            ((TileQuestBarrier)tileEntity).readFromItem(stack);
        }
    }

    @Deprecated
    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileQuestBarrier && ((TileQuestBarrier)tileEntity).completed) {
            return state.func_177226_a((IProperty)COMPLETED, (Comparable)Boolean.valueOf(true));
        }
        return state;
    }

    @Deprecated
    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing facing) {
        return world.func_180495_p(pos.func_177972_a(facing)).func_177230_c() != this && super.func_176225_a(state, world, pos, facing);
    }
}

