/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.lib.io;

import com.feed_the_beast.ftblib.lib.io.DataReader;
import com.feed_the_beast.ftblib.lib.util.JsonUtils;
import com.google.gson.JsonElement;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.imageio.ImageIO;

public class StreamDataReader
extends DataReader {
    public final InputStream stream;

    StreamDataReader(InputStream s) {
        this.stream = s;
    }

    public String toString() {
        return this.stream.toString();
    }

    @Override
    public String string(int bufferSize) throws Exception {
        try {
            String string = StreamDataReader.readStringFromStream(this.stream, bufferSize);
            return string;
        }
        finally {
            this.stream.close();
        }
    }

    @Override
    public List<String> stringList() throws Exception {
        try {
            List<String> list = StreamDataReader.readStringListFromStream(this.stream);
            return list;
        }
        finally {
            this.stream.close();
        }
    }

    @Override
    public JsonElement json() throws Exception {
        try {
            JsonElement jsonElement = JsonUtils.parse(new InputStreamReader(this.stream, StandardCharsets.UTF_8));
            return jsonElement;
        }
        finally {
            this.stream.close();
        }
    }

    @Override
    public BufferedImage image() throws Exception {
        try {
            BufferedImage bufferedImage = ImageIO.read(this.stream);
            return bufferedImage;
        }
        finally {
            this.stream.close();
        }
    }
}

