/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.lib.icon;

import com.feed_the_beast.ftblib.lib.gui.GuiHelper;
import com.feed_the_beast.ftblib.lib.icon.Color4I;
import com.feed_the_beast.ftblib.lib.icon.Icon;
import com.feed_the_beast.ftblib.lib.icon.IconProperties;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class HollowRectangleIcon
extends Icon {
    public Color4I color;
    public boolean roundEdges;

    public HollowRectangleIcon(Color4I c, boolean r) {
        this.color = c;
        this.roundEdges = r;
    }

    @Override
    public HollowRectangleIcon copy() {
        return new HollowRectangleIcon(this.color, this.roundEdges);
    }

    @Override
    public HollowRectangleIcon withColor(Color4I color) {
        return new HollowRectangleIcon(color, this.roundEdges);
    }

    @Override
    public HollowRectangleIcon withTint(Color4I c) {
        return this.withColor(this.color.withTint(c));
    }

    @Override
    protected void setProperties(IconProperties properties) {
        super.setProperties(properties);
        this.roundEdges = properties.getBoolean("round_edges", this.roundEdges);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void draw(int x, int y, int w, int h) {
        GuiHelper.drawHollowRect(x, y, w, h, this.color, this.roundEdges);
    }

    @Override
    public JsonElement getJson() {
        JsonObject o = new JsonObject();
        o.addProperty("id", "hollow_rectangle");
        o.add("color", this.color.getJson());
        if (this.roundEdges) {
            o.addProperty("round_edges", Boolean.valueOf(true));
        }
        return o;
    }
}

