/*
 * Decompiled with CFR 0.152.
 */
package engineers.workshop.common.network.data;

import engineers.workshop.common.network.data.DataBase;
import engineers.workshop.common.table.TileTable;
import engineers.workshop.common.unit.Unit;
import net.minecraft.nbt.NBTTagCompound;

public abstract class DataUnit
extends DataBase {
    public static final int LENGTH = 8;

    public static int getId(Unit unit) {
        return unit.getId() * 2;
    }

    protected Unit getUnit(TileTable table, int id) {
        Unit smelt = table.getMainPage().getSmeltingList().get(id /= 2);
        Unit craft = table.getMainPage().getCraftingList().get(id);
        Unit storage = table.getMainPage().getStorageList().get(id);
        if (smelt.isEnabled()) {
            return smelt;
        }
        if (storage.isEnabled()) {
            return storage;
        }
        return craft;
    }

    public static class Charged
    extends DataUnit {
        @Override
        public void save(TileTable table, NBTTagCompound dw, int id) {
            dw.func_74768_a("id", id);
            dw.func_74768_a("charge", this.getUnit(table, id).getChargeCount());
        }

        @Override
        public void load(TileTable table, NBTTagCompound dr, int id) {
            this.getUnit(table, id).setChargeCount(dr.func_74762_e("charge"));
        }
    }

    public static class Progress
    extends DataUnit {
        @Override
        public void save(TileTable table, NBTTagCompound dw, int id) {
            dw.func_74768_a("progress", this.getUnit(table, id).getProductionProgress());
        }

        @Override
        public void load(TileTable table, NBTTagCompound dr, int id) {
            this.getUnit(table, id).setProductionProgress(dr.func_74762_e("progress"));
        }
    }
}

