/*
 * Decompiled with CFR 0.152.
 */
package engineers.workshop.common;

import java.io.File;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.registry.GameRegistry;

@GameRegistry.ObjectHolder(value="engineersworkshop")
public final class Config {
    public static void loadConfig(File file) {
        Configuration config = new Configuration(file);
        config.load();
        new TWEAKS(config, "Tweaks").load();
        new POWER(config, "Power").load();
        new MACHINES(config, "Machines").load();
        config.save();
    }

    public static class MACHINES
    extends ConfigHandler {
        public static String[] CRAFTER_BLOCKS;
        public static String[] FURNACE_BLOCKS;
        public static String[] CRUSHER_BLOCKS;
        public static String[] ALLOY_BLOCKS;
        public static String[] STORAGE_BLOCKS;

        public MACHINES(Configuration config, String category) {
            super(config, category);
        }

        @Override
        public void load() {
            CRAFTER_BLOCKS = this.config.getStringList("Crafter Blocks", "Machines", new String[]{"minecraft:crafting_table"}, "What blocks should the table accept for crafters.");
            FURNACE_BLOCKS = this.config.getStringList("Furnace Blocks", "Machines", new String[]{"minecraft:furnace"}, "What blocks should the table accept for furances.");
            CRUSHER_BLOCKS = this.config.getStringList("Crusher Blocks", "Machines", new String[]{"enderio:blockSagMill"}, "What blocks should the table accept for crushers.");
            ALLOY_BLOCKS = this.config.getStringList("Alloy Blocks", "Machines", new String[]{"enderio:blockAlloySmelter"}, "What blocks should the table accept for alloy smelters.");
            STORAGE_BLOCKS = this.config.getStringList("Storage Blocks", "Machines", new String[]{"minecraft:chest"}, "What blocks should the table accept for storage.");
        }
    }

    public static class POWER
    extends ConfigHandler {
        public static boolean RF_SUPPORT;

        public POWER(Configuration config, String category) {
            super(config, category);
        }

        @Override
        public void load() {
            RF_SUPPORT = this.config.getBoolean("RF Support", "Power", true, "Should RF upgrades be allowed?");
        }
    }

    public static class TWEAKS
    extends ConfigHandler {
        public static int FUEL_DELAY;

        public TWEAKS(Configuration config, String category) {
            super(config, category);
        }

        @Override
        public void load() {
            FUEL_DELAY = this.config.getInt("Fuel Delay", this.category, 15, 0, Integer.MAX_VALUE, "Sets the amount of ticks between each time the worktable consumes a fuel resource");
        }
    }

    private static abstract class ConfigHandler {
        protected String category;
        protected Configuration config;

        public ConfigHandler(Configuration config, String category) {
            this.category = category;
            this.config = config;
        }

        public abstract void load();
    }
}

