/*
 * Decompiled with CFR 0.152.
 */
package engineers.workshop.client.container.slot;

import engineers.workshop.client.GuiBase;
import engineers.workshop.client.container.slot.SlotTable;
import engineers.workshop.client.page.Page;
import engineers.workshop.common.items.ItemUpgrade;
import engineers.workshop.common.items.Upgrade;
import engineers.workshop.common.table.TileTable;
import net.minecraft.item.ItemStack;

public class SlotUpgrade
extends SlotTable {
    private SlotUpgrade main;
    private boolean isMain;
    private int upgradeSection;

    public SlotUpgrade(TileTable table, Page page, int id, int x, int y, SlotUpgrade main, int upgradeSection) {
        super(table, page, id, x, y);
        this.main = main;
        this.isMain = main == null && upgradeSection < 4;
        this.upgradeSection = upgradeSection;
    }

    @Override
    public int getSlotStackLimit(ItemStack item) {
        if (this.isMain) {
            return 1;
        }
        Upgrade upgrade = ItemUpgrade.getUpgrade(item);
        if (upgrade != null) {
            int count = this.table.getUpgradePage().getUpgradeCount(this.upgradeSection, upgrade);
            return Math.min(64, upgrade.getMaxCount() - count + (!this.func_75211_c().func_190926_b() ? this.func_75211_c().func_190916_E() : 0));
        }
        return super.getSlotStackLimit(item);
    }

    @Override
    public boolean func_75214_a(ItemStack itemstack) {
        return super.func_75214_a(itemstack) && (itemstack.func_190926_b() || (this.isMain ? this.isMainItem(itemstack) : this.isUpgradeItem(itemstack)));
    }

    private boolean isUpgradeItem(ItemStack itemstack) {
        Upgrade upgrade = ItemUpgrade.getUpgrade(itemstack);
        return upgrade != null && upgrade.isValid(this.main != null ? this.main.func_75211_c() : ItemStack.field_190927_a) && (upgrade.getDependency() == null || this.table.getUpgradePage().getUpgradeCount(this.upgradeSection, upgrade.getDependency()) > 0);
    }

    private boolean isMainItem(ItemStack stack) {
        return Upgrade.ParentType.CRAFTING.isValidParent(stack) || Upgrade.ParentType.SMELTING.isValidParent(stack) || Upgrade.ParentType.CRUSHING.isValidParent(stack) || Upgrade.ParentType.ALLOY.isValidParent(stack) || Upgrade.ParentType.STORAGE.isValidParent(stack);
    }

    @Override
    public boolean func_111238_b() {
        return this.main == null || this.main.func_75216_d();
    }

    @Override
    public int getTextureIndex(GuiBase gui) {
        if (this.isMain) {
            if (this.func_75216_d()) {
                return 2;
            }
        } else {
            Upgrade upgrade = ItemUpgrade.getUpgrade(this.func_75211_c());
            if (!(upgrade == null || this.table.getUpgradePage().getUpgradeCountRaw(this.upgradeSection, upgrade) <= upgrade.getMaxCount() && this.isUpgradeItem(this.func_75211_c()))) {
                return 4;
            }
        }
        return super.getTextureIndex(gui);
    }

    public void func_75218_e() {
        super.func_75218_e();
        this.table.onUpgradeChangeDistribute();
    }

    @Override
    public boolean canDragIntoSlot() {
        return this.isMain;
    }

    @Override
    public boolean canPickUpOnDoubleClick() {
        return false;
    }
}

