/*
 * Decompiled with CFR 0.152.
 */
package engineers.workshop.client;

import engineers.workshop.client.container.slot.SlotBase;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public abstract class GuiBase
extends GuiContainer {
    protected static final ResourceLocation BACKGROUND = new ResourceLocation("engineersworkshop", "textures/gui/background.png");
    protected static final ResourceLocation ELEMENTS = new ResourceLocation("engineersworkshop", "textures/gui/elements_gl.png");
    private static final int ITEM_SIZE = 18;
    private static final int ITEM_SRC_X = 68;
    private static final int ITEM_SRC_Y = 62;
    private static final int ITEM_ITEM_OFFSET = 1;
    public boolean shiftMoveRendered;
    private SlotBase selectedSlot;
    private List<String> mouseOver;

    public GuiBase(Container container) {
        super(container);
    }

    public void func_73863_a(int x, int y, float f) {
        this.func_146276_q_();
        this.selectedSlot = null;
        this.shiftMoveRendered = false;
        for (Object obj : this.field_147002_h.field_75151_b) {
            SlotBase slot = (SlotBase)((Object)obj);
            if (!this.func_146978_c(slot.field_75223_e, slot.field_75221_f, 16, 16, x, y)) continue;
            this.selectedSlot = slot;
            break;
        }
        this.clearMouseOverCache();
        super.func_73863_a(x, y, f);
        this.func_191948_b(x, y);
    }

    public SlotBase getSelectedSlot() {
        return this.selectedSlot;
    }

    public void prepare() {
        this.field_146297_k.func_110434_K().func_110577_a(ELEMENTS);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179140_f();
    }

    public boolean inBounds(int x, int y, int w, int h, int mX, int mY) {
        return x <= mX && mX < x + w && y <= mY && mY < y + h;
    }

    public void drawRect(int x, int y, int u, int v, int w, int h) {
        this.func_73729_b(x, y, u, v, w, h);
    }

    public void drawString(String str, int x, int y, int color) {
        this.drawString(str, x, y, 1.0f, color);
    }

    public void drawString(String str, int x, int y, float multiplier, int color) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)multiplier, (float)multiplier, (float)1.0f);
        this.field_146289_q.func_78276_b(str, (int)((float)x / multiplier), (int)((float)y / multiplier), color);
        GlStateManager.func_179121_F();
    }

    public void drawCenteredString(String str, int x, int y, int width, float multiplier, int color) {
        this.drawString(str, x + (width - (int)((float)this.field_146289_q.func_78256_a(str) * multiplier)) / 2, y, multiplier, color);
    }

    public void drawItem(ItemStack item, int x, int y) {
        RenderHelper.func_74520_c();
        if (!item.func_190926_b()) {
            this.field_146296_j.func_180450_b(item, x, y);
        }
    }

    public void drawItemWithBackground(ItemStack item, int x, int y, int mX, int mY) {
        boolean hover = this.inBounds(x, y, 18, 18, mX, mY);
        int textureIndexX = hover ? 1 : 0;
        int textureIndexY = !item.func_190926_b() ? 1 : 0;
        this.prepare();
        this.drawRect(x, y, 68 + textureIndexX * 18, 62 + textureIndexY * 18, 18, 18);
        this.drawItem(item, x + 1, y + 1);
        if (hover) {
            this.drawMouseOver(this.getItemDescription(item));
        }
    }

    public int getStringWidth(String str) {
        return this.field_146289_q.func_78256_a(str);
    }

    public void drawCursor(int x, int y, int z, float size, int color) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)x, (float)y, (float)z);
        GlStateManager.func_179152_a((float)size, (float)size, (float)0.0f);
        GlStateManager.func_179109_b((float)(-x), (float)(-y), (float)0.0f);
        Gui.func_73734_a((int)x, (int)(y + 1), (int)(x + 1), (int)(y + 10), (int)color);
        GlStateManager.func_179121_F();
    }

    public void drawMouseOver(String str) {
        if (str == null) {
            return;
        }
        ArrayList<String> lst = new ArrayList<String>();
        Collections.addAll(lst, str.split("\n"));
        this.drawMouseOver(lst);
    }

    public void drawMouseOver(List<String> str) {
        this.mouseOver = str;
    }

    public void clearMouseOverCache() {
        this.mouseOver = null;
    }

    protected void func_146979_b(int mX, int mY) {
        this.drawCachedMouseOver(mX - this.field_147003_i, mY - this.field_147009_r);
    }

    public void drawCachedMouseOver(int x, int y) {
        if (this.mouseOver == null || this.mouseOver.isEmpty()) {
            return;
        }
        int w = 0;
        for (String line : this.mouseOver) {
            int l = this.field_146289_q.func_78256_a(line);
            if (l <= w) continue;
            w = l;
        }
        x += 12;
        y -= 12;
        int h = 8;
        if (this.mouseOver.size() > 1) {
            h += 2 + (this.mouseOver.size() - 1) * 10;
        }
        if (this.field_147003_i + x + w > this.field_146294_l) {
            x -= 28 + w;
        }
        if (this.field_147009_r + y + h + 6 > this.field_146295_m) {
            y = this.field_146295_m - h - 6 - this.field_147009_r;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)300.0f);
        this.field_73735_i = 300.0f;
        int bg = -267386864;
        this.func_73733_a(x - 3, y - 4, x + w + 3, y - 3, bg, bg);
        this.func_73733_a(x - 3, y + h + 3, x + w + 3, y + h + 4, bg, bg);
        this.func_73733_a(x - 3, y - 3, x + w + 3, y + h + 3, bg, bg);
        this.func_73733_a(x - 4, y - 3, x - 3, y + h + 3, bg, bg);
        this.func_73733_a(x + w + 3, y - 3, x + w + 4, y + h + 3, bg, bg);
        int border1 = 0x505000FF;
        int border2 = (border1 & 0xFEFEFE) >> 1 | border1 & 0xFF000000;
        this.func_73733_a(x - 3, y - 3 + 1, x - 3 + 1, y + h + 3 - 1, border1, border2);
        this.func_73733_a(x + w + 2, y - 3 + 1, x + w + 3, y + h + 3 - 1, border1, border2);
        this.func_73733_a(x - 3, y - 3, x + w + 3, y - 3 + 1, border1, border1);
        this.func_73733_a(x - 3, y + h + 2, x + w + 3, y + h + 3, border2, border2);
        GlStateManager.func_179097_i();
        for (int i = 0; i < this.mouseOver.size(); ++i) {
            String line = this.mouseOver.get(i);
            this.field_146289_q.func_175063_a(line, (float)x, (float)y, -1);
            if (i == 0) {
                y += 2;
            }
            y += 10;
        }
        this.field_73735_i = 0.0f;
        GlStateManager.func_179121_F();
        GlStateManager.func_179126_j();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public String getItemName(ItemStack item) {
        if (item.func_190926_b()) {
            return null;
        }
        try {
            return item.func_82833_r();
        }
        catch (Throwable ignored) {
            return null;
        }
    }

    public List<String> getItemDescription(ItemStack item) {
        if (item.func_190926_b()) {
            return null;
        }
        try {
            return item.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, (ITooltipFlag)(Minecraft.func_71410_x().field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL));
        }
        catch (Throwable ignored) {
            return null;
        }
    }
}

