/*
 * Decompiled with CFR 0.152.
 */
package com.myuki69.enderquarry;

import com.myuki69.enderquarry.EnderQuarryMod;
import com.myuki69.enderquarry.TileEnderMarker;
import com.myuki69.enderquarry.UpgradeBlock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.IGrowable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.wrappers.BlockLiquidWrapper;
import net.minecraftforge.fluids.capability.wrappers.FluidBlockWrapper;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class TileEnderQuarry
extends TileEntity
implements ITickable,
IItemHandler {
    private static final Random rand = new Random();
    public static int baseDrain = 1800;
    public static float hardnessDrain = 200.0f;
    public ArrayList<ItemStack> items = new ArrayList();
    public FluidTank tank = new FluidTank(32000);
    public EnergyStorage energy = new EnergyStorage(10000000);
    public int neededEnergy = -1;
    public int config = -1;
    public long progress = 0L;
    public boolean started = false;
    public boolean finished = false;
    public int dx = 1;
    public int dy = 0;
    public int dz = 0;
    int chunk_x = 0;
    int chunk_z = 0;
    int chunk_y = 0;
    int xCoord;
    int yCoord;
    int zCoord;
    int min_x;
    int max_x;
    int min_z;
    int max_z;
    private ForgeChunkManager.Ticket chunkTicket;
    private EntityPlayer owner;
    public static double[] powerMultipliers = new double[]{1.0, 1.0, 1.5, 5.0, 20.0, 80.0, 1.0, 1.5, 2.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
    public boolean[] upgrades = new boolean[16];
    public static final int UPGRADE_BLANK = 0;
    public static final int UPGRADE_VOID = 1;
    public static final int UPGRADE_SILK = 2;
    public static final int UPGRADE_FORTUNE1 = 3;
    public static final int UPGRADE_FORTUNE2 = 4;
    public static final int UPGRADE_FORTUNE3 = 5;
    public static final int UPGRADE_SPEED1 = 6;
    public static final int UPGRADE_SPEED2 = 7;
    public static final int UPGRADE_SPEED3 = 8;
    public static final int UPGRADE_FLUID = 9;

    public TileEnderQuarry() {
        this.tank.setCanFill(false);
    }

    public void func_145839_a(NBTTagCompound tags) {
        this.energy.receiveEnergy(tags.func_74762_e("energy"), false);
        int n = tags.func_74762_e("item_no");
        this.items.clear();
        for (int i = 0; i < n; ++i) {
            NBTTagCompound t = tags.func_74775_l("item_" + i);
            this.items.add(new ItemStack(t));
        }
        if (tags.func_74764_b("fluid")) {
            this.tank.fillInternal(FluidStack.loadFluidStackFromNBT((NBTTagCompound)tags.func_74775_l("fluid")), true);
        }
        this.finished = tags.func_74767_n("finished");
        if (this.finished) {
            return;
        }
        this.started = tags.func_74767_n("started");
        if (!this.started) {
            return;
        }
        this.min_x = tags.func_74762_e("min_x");
        this.min_z = tags.func_74762_e("min_z");
        this.max_x = tags.func_74762_e("max_x");
        this.max_z = tags.func_74762_e("max_z");
        this.chunk_x = tags.func_74762_e("chunk_x");
        this.chunk_y = tags.func_74762_e("chunk_y");
        this.chunk_z = tags.func_74762_e("chunk_z");
        this.dx = tags.func_74762_e("dx");
        this.dy = tags.func_74762_e("dy");
        this.dz = tags.func_74762_e("dz");
        this.progress = tags.func_74763_f("progress");
        super.func_145839_a(tags);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tags) {
        tags.func_74768_a("energy", this.energy.getEnergyStored());
        for (int i = 0; i < this.items.size(); ++i) {
            while (i < this.items.size() && this.items.get(i) == null) {
                this.items.remove(i);
            }
            if (i >= this.items.size()) continue;
            NBTTagCompound t = new NBTTagCompound();
            this.items.get(i).func_77955_b(t);
            tags.func_74782_a("item_" + i, (NBTBase)t);
        }
        tags.func_74768_a("item_no", this.items.size());
        if (this.tank.getFluid() != null) {
            NBTTagCompound t = new NBTTagCompound();
            this.tank.getFluid().writeToNBT(t);
            tags.func_74782_a("fluid", (NBTBase)t);
        }
        if (this.finished) {
            tags.func_74757_a("finished", true);
        } else if (this.started) {
            tags.func_74757_a("started", true);
            tags.func_74768_a("min_x", this.min_x);
            tags.func_74768_a("max_x", this.max_x);
            tags.func_74768_a("min_z", this.min_z);
            tags.func_74768_a("max_z", this.max_z);
            tags.func_74768_a("chunk_x", this.chunk_x);
            tags.func_74768_a("chunk_y", this.chunk_y);
            tags.func_74768_a("chunk_z", this.chunk_z);
            tags.func_74768_a("dx", this.dx);
            tags.func_74768_a("dy", this.dy);
            tags.func_74768_a("dz", this.dz);
            tags.func_74772_a("progress", this.progress);
        }
        return super.func_189515_b(tags);
    }

    public boolean checkForMarkers(EntityPlayer player) {
        BlockPos thisBlockPos = this.func_174877_v();
        System.out.println("Quarry checking at: " + thisBlockPos.func_177958_n() + " " + thisBlockPos.func_177956_o() + " " + thisBlockPos.func_177952_p());
        for (EnumFacing face : EnumFacing.field_176754_o) {
            BlockPos vecin = thisBlockPos.func_177972_a(face);
            int offsetX = vecin.func_177958_n() - thisBlockPos.func_177958_n();
            int offsetZ = vecin.func_177952_p() - thisBlockPos.func_177952_p();
            int[] test = new int[]{this.field_145850_b.field_73011_w.getDimension(), vecin.func_177958_n(), vecin.func_177956_o(), vecin.func_177952_p()};
            int[] test_forward = null;
            int[] test_side = null;
            boolean foundAttached = false;
            for (int[] a : TileEnderMarker.markers) {
                if (!TileEnderQuarry.isIntEqual(a, test)) continue;
                foundAttached = true;
                break;
            }
            if (!foundAttached) continue;
            player.func_145747_a((ITextComponent)new TextComponentString("Found attached ender-marker"));
            for (int[] a : TileEnderMarker.markers) {
                if (a[0] != test[0] || a[2] != test[2] || a[1] == test[1] && a[3] == test[3]) continue;
                if (TileEnderQuarry.sign(a[1] - test[1]) == offsetX && TileEnderQuarry.sign(a[3] - test[3]) == offsetZ) {
                    if (test_forward == null) {
                        test_forward = a;
                    } else if (!TileEnderQuarry.isIntEqual(a, test_forward)) {
                        player.func_145747_a((ITextComponent)new TextComponentString("Quarry marker square is ambiguous - multiple markers found at (" + a[1] + "," + a[3] + ") and (" + test_forward[1] + "," + test_forward[3] + ")"));
                    }
                }
                if ((offsetX != 0 || a[3] != test[3]) && (offsetZ != 0 || a[1] != test[1])) continue;
                if (test_side == null) {
                    test_side = a;
                    continue;
                }
                if (TileEnderQuarry.isIntEqual(a, test_side)) continue;
                player.func_145747_a((ITextComponent)new TextComponentString("Quarry marker square is ambiguous - multiple markers found at (" + a[1] + "," + a[3] + ") and (" + test_side[1] + "," + test_side[3] + ")"));
            }
            if (test_forward == null) {
                player.func_145747_a((ITextComponent)new TextComponentString("Quarry marker square is incomplete"));
                return false;
            }
            if (test_side == null) {
                player.func_145747_a((ITextComponent)new TextComponentString("Quarry marker square is incomplete"));
                return false;
            }
            int amin_x = Math.min(Math.min(test[1], (int)test_forward[1]), (int)test_side[1]);
            int amax_x = Math.max(Math.max(test[1], (int)test_forward[1]), (int)test_side[1]);
            int amin_z = Math.min(Math.min(test[3], (int)test_forward[3]), (int)test_side[3]);
            int amax_z = Math.max(Math.max(test[3], (int)test_forward[3]), test_side[3]);
            if (amax_x - amin_x <= 2 || amax_z - amin_z <= 2) {
                player.func_145747_a((ITextComponent)new TextComponentString("Region created by ender markers is too small"));
                return false;
            }
            player.func_145747_a((ITextComponent)new TextComponentString("Sucessfully established boundary"));
            this.chunk_y = this.func_174877_v().func_177956_o();
            this.min_x = amin_x;
            this.max_x = amax_x;
            this.min_z = amin_z;
            this.max_z = amax_z;
            this.startDig();
            return true;
        }
        return false;
    }

    public static boolean isIntEqual(int[] a, int[] b) {
        if (a == b) {
            return true;
        }
        for (int i = 0; i < 4; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    public static int sign(int d) {
        if (d == 0) {
            return 0;
        }
        if (d > 0) {
            return 1;
        }
        return -1;
    }

    public void startDig() {
        System.out.println("Ender quarry started digging at (" + this.min_x + ", " + this.min_z + "), (" + this.max_x + ", " + this.max_z + ")");
        this.started = true;
        this.chunk_x = this.min_x + 1 >> 4;
        this.chunk_z = this.min_z + 1 >> 4;
        this.dx = Math.max(0, this.min_x + 1 - (this.chunk_x << 4));
        this.dy = this.chunk_y;
        this.dz = Math.max(0, this.min_z + 1 - (this.chunk_z << 4));
        if (!this.stopHere()) {
            this.nextBlock();
        }
    }

    public void func_73660_a() {
        this.xCoord = this.func_174877_v().func_177958_n();
        this.yCoord = this.func_174877_v().func_177956_o();
        this.zCoord = this.func_174877_v().func_177952_p();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.config == -1) {
            this.checkSurroundings();
        }
        if (!this.started || this.finished) {
            return;
        }
        if (this.chunkTicket == null) {
            this.chunkTicket = ForgeChunkManager.requestTicket((Object)EnderQuarryMod.instance, (World)this.field_145850_b, (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
            if (this.chunkTicket == null) {
                if (this.owner != null) {
                    this.owner.func_145747_a((ITextComponent)new TextComponentString("Problem registering chunk-preserving method"));
                }
                this.finished = true;
                return;
            }
            this.chunkTicket.getModData().func_74778_a("id", "quarry");
            this.chunkTicket.getModData().func_74768_a("x", this.xCoord);
            this.chunkTicket.getModData().func_74768_a("y", this.yCoord);
            this.chunkTicket.getModData().func_74768_a("z", this.zCoord);
            ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.chunkTicket, (ChunkPos)new ChunkPos(this.xCoord, this.zCoord));
            this.loadChunk();
        }
        int nr = this.getSpeedStack();
        for (int k = 0; k < nr; ++k) {
            TileEntity tile;
            BlockPos vecin;
            if (!this.hasRedstoneSignal() && this.items.isEmpty() && (this.tank.getFluid() == null || this.tank.getFluidAmount() <= 31000) && this.energy.getEnergyStored() >= this.neededEnergy && this.energy.extractEnergy(baseDrain, true) == baseDrain) {
                int x = (this.chunk_x << 4) + this.dx;
                int z = (this.chunk_z << 4) + this.dz;
                int y = this.dy;
                if (y >= 0) {
                    if (this.mineBlock(x, y, z, !this.upgrades[1])) {
                        this.neededEnergy = -1;
                        this.nextBlock();
                    }
                } else {
                    this.nextBlock();
                }
            }
            if (!this.items.isEmpty() && this.config > 0) {
                BlockPos thisBlockPos = this.func_174877_v();
                for (EnumFacing face : EnumFacing.values()) {
                    vecin = thisBlockPos.func_177972_a(face);
                    tile = this.field_145850_b.func_175625_s(vecin);
                    if (tile == null || !tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, face.func_176734_d())) continue;
                    IItemHandler itemhandler = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, face.func_176734_d());
                    for (int i = 0; i < this.items.size(); ++i) {
                        ItemStack remainder = ItemHandlerHelper.insertItemStacked((IItemHandler)itemhandler, (ItemStack)this.items.get(i), (boolean)false);
                        if (!remainder.func_190926_b()) continue;
                        this.items.remove(i);
                        --i;
                    }
                }
            }
            if (this.tank.getFluid() == null || this.tank.getFluidAmount() <= 0 || this.config <= 0) continue;
            BlockPos thisBlockPos = this.func_174877_v();
            for (EnumFacing face : EnumFacing.values()) {
                vecin = thisBlockPos.func_177972_a(face);
                tile = this.field_145850_b.func_175625_s(vecin);
                if (tile == null || !tile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, face.func_176734_d())) continue;
                IFluidHandler handler = (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, face.func_176734_d());
                this.tank.drain(handler.fill(this.tank.getFluid(), true), true);
            }
        }
    }

    public boolean mineBlock(int x, int y, int z, boolean replaceWithDirt) {
        BlockPos miningPos = new BlockPos(x, y, z);
        BlockLiquidWrapper handler = null;
        IBlockState toBeMinedState = this.field_145850_b.func_180495_p(miningPos);
        Block toBeMined = toBeMinedState.func_177230_c();
        if (this.field_145850_b.func_175623_d(miningPos)) {
            return true;
        }
        if (toBeMined instanceof BlockLiquid) {
            handler = new BlockLiquidWrapper((BlockLiquid)toBeMined, this.field_145850_b, miningPos);
        } else if (toBeMined instanceof IFluidBlock) {
            handler = new FluidBlockWrapper((IFluidBlock)toBeMined, this.field_145850_b, miningPos);
        }
        if (handler != null) {
            if (this.upgrades[9]) {
                FluidStack drained = handler.drain(16000, false);
                if (drained != null && this.tank.fillInternal(drained, false) == drained.amount) {
                    this.tank.fillInternal(handler.drain(16000, true), true);
                    this.field_145850_b.func_175656_a(miningPos, Blocks.field_150350_a.func_176223_P());
                    return true;
                }
                if (drained == null) {
                    System.out.println("WARNING: Draining block at " + x + ", " + y + ", " + z + " - " + toBeMined.func_149732_F() + " returned null! Skipping!");
                    return true;
                }
                return false;
            }
            return true;
        }
        if (toBeMined == Blocks.field_150357_h) {
            return true;
        }
        if (replaceWithDirt && toBeMined == Blocks.field_150346_d) {
            return true;
        }
        if (replaceWithDirt && (toBeMined.isLeaves(toBeMinedState, (IBlockAccess)this.field_145850_b, miningPos) || toBeMined.isFoliage((IBlockAccess)this.field_145850_b, miningPos) || toBeMined.isWood((IBlockAccess)this.field_145850_b, miningPos) || toBeMined instanceof IPlantable || toBeMined instanceof IGrowable)) {
            return true;
        }
        int meta = toBeMined.func_176201_c(toBeMinedState);
        float hardness = toBeMinedState.func_185887_b(this.field_145850_b, miningPos);
        if (hardness < 0.0f) {
            return true;
        }
        int amount = (int)Math.ceil((double)baseDrain + (double)(hardness * hardnessDrain) * this.getPowerMultiplier());
        if (amount > this.energy.getMaxEnergyStored()) {
            amount = this.energy.getMaxEnergyStored();
        }
        if (this.energy.extractEnergy(amount, true) < amount) {
            this.neededEnergy = amount;
            return false;
        }
        this.energy.extractEnergy(amount, false);
        if (toBeMined == Blocks.field_150349_c && this.field_145850_b.func_175678_i(miningPos)) {
            return true;
        }
        return this.harvestBlock(toBeMinedState, miningPos, meta, replaceWithDirt, this.getDigType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean harvestBlock(IBlockState toBeMinedState, BlockPos miningPos, int meta, boolean replaceWithDirt, DigType digType) {
        Block toBeMined = toBeMinedState.func_177230_c();
        boolean isOpaque = toBeMinedState.func_185914_p();
        FakePlayer fakePlayer = FakePlayerFactory.getMinecraft((WorldServer)((WorldServer)this.field_145850_b));
        fakePlayer.func_184201_a(EntityEquipmentSlot.MAINHAND, digType.newStack(Items.field_151046_w));
        try {
            boolean flag;
            ArrayList<ItemStack> i = new ArrayList<ItemStack>();
            TileEntity tile = this.field_145850_b.func_175625_s(miningPos);
            if (tile != null && tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
                System.out.println("Found inventory containing tile at " + miningPos);
                IItemHandler inv = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
                for (int j = 0; j < inv.getSlots(); ++j) {
                    if (inv.getStackInSlot(j).func_190926_b()) continue;
                    System.out.println("[Ender quarry] Extracting from inventory slot " + j + " " + inv.getStackInSlot(j));
                    int cnt = inv.getStackInSlot(j).func_190916_E();
                    i.add(inv.extractItem(j, cnt, false));
                }
            }
            if (digType.isSilkTouch() && toBeMined.canSilkHarvest(this.field_145850_b, miningPos, toBeMinedState, (EntityPlayer)fakePlayer)) {
                int j = 0;
                Item item = Item.func_150898_a((Block)toBeMined);
                if (item != null) {
                    if (item.func_77614_k()) {
                        j = meta;
                    }
                    ItemStack itemstack = new ItemStack(item, 1, j);
                    i.add(itemstack);
                }
            } else {
                i.addAll(toBeMined.getDrops((IBlockAccess)this.field_145850_b, miningPos, toBeMinedState, digType.getFortuneModifier()));
            }
            float p = ForgeEventFactory.fireBlockHarvesting(i, (World)this.field_145850_b, (BlockPos)miningPos, (IBlockState)toBeMinedState, (int)digType.getFortuneModifier(), (float)1.0f, (boolean)digType.isSilkTouch(), (EntityPlayer)fakePlayer);
            if (p > 0.0f && !i.isEmpty() && (p == 1.0f || rand.nextFloat() < p)) {
                this.items.addAll((Collection<ItemStack>)i);
            }
            if (replaceWithDirt) {
                if (toBeMined == Blocks.field_150346_d) {
                    boolean bl = true;
                    return bl;
                }
                flag = this.field_145850_b.func_175656_a(miningPos, Blocks.field_150346_d.func_176223_P());
            } else {
                flag = this.field_145850_b.func_175656_a(miningPos, Blocks.field_150350_a.func_176223_P());
            }
            if (!flag) {
                System.out.println("Error in setting block at mining pos!");
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            fakePlayer.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(Blocks.field_150346_d));
        }
    }

    private DigType getDigType() {
        if (this.upgrades[2]) {
            return DigType.SILK;
        }
        if (this.upgrades[3]) {
            return DigType.FORTUNE;
        }
        if (this.upgrades[4]) {
            return DigType.FORTUNE2;
        }
        if (this.upgrades[5]) {
            return DigType.FORTUNE3;
        }
        return DigType.NORMAL;
    }

    public void nextBlock() {
        this.nextSubBlock();
        while (!this.stopHere()) {
            this.nextSubBlock();
        }
    }

    public void nextSubBlock() {
        ++this.progress;
        --this.dy;
        if (this.dy <= 0) {
            ++this.dx;
            if (this.dx >= 16 || (this.chunk_x << 4) + this.dx >= this.max_x) {
                this.dx = Math.max(0, this.min_x + 1 - (this.chunk_x << 4));
                ++this.dz;
                if (this.dz >= 16 || (this.chunk_z << 4) + this.dz >= this.max_z) {
                    this.nextChunk();
                    this.dx = Math.max(0, this.min_x + 1 - (this.chunk_x << 4));
                    this.dz = Math.max(0, this.min_z + 1 - (this.chunk_z << 4));
                }
            }
            this.dy = this.chunk_y;
        }
    }

    public void nextChunk() {
        this.unloadChunk();
        ++this.chunk_x;
        if (this.chunk_x << 4 >= this.max_x) {
            this.chunk_x = this.min_x + 1 >> 4;
            ++this.chunk_z;
            if (this.chunk_z << 4 >= this.max_z) {
                this.finished = true;
                ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.chunkTicket);
                return;
            }
        }
        this.dy = this.chunk_y;
        this.loadChunk();
    }

    public boolean stopHere() {
        return this.finished || this.isValid((this.chunk_x << 4) + this.dx, (this.chunk_z << 4) + this.dz);
    }

    private boolean isValid(int x, int z) {
        return this.min_x < x && x < this.max_x && this.min_z < z && z < this.max_z;
    }

    private double getPowerMultiplier() {
        double multiplier = 1.0;
        for (int i = 0; i < 16; ++i) {
            if (!this.upgrades[i]) continue;
            multiplier *= powerMultipliers[i];
        }
        return multiplier;
    }

    private int getSpeedStack() {
        if (this.upgrades[6]) {
            return 1;
        }
        if (this.upgrades[7]) {
            return 3;
        }
        if (this.upgrades[8]) {
            return 9;
        }
        return 1;
    }

    private void loadChunk() {
        ChunkPos base = new ChunkPos(this.xCoord, this.zCoord);
        if (base.field_77276_a != this.chunk_x || base.field_77275_b != this.chunk_z) {
            ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.chunkTicket, (ChunkPos)new ChunkPos(this.chunk_x, this.chunk_z));
        }
    }

    private void unloadChunk() {
        ChunkPos base = new ChunkPos(this.xCoord, this.zCoord);
        if (base.field_77276_a != this.chunk_x || base.field_77275_b != this.chunk_z) {
            ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)this.chunkTicket, (ChunkPos)new ChunkPos(this.chunk_x, this.chunk_z));
        }
    }

    public void checkSurroundings() {
        this.config = 1;
        for (int i = 0; i <= 10; ++i) {
            this.upgrades[i] = false;
        }
        BlockPos thisBlockPos = this.func_174877_v();
        for (EnumFacing face : EnumFacing.values()) {
            BlockPos vecin = thisBlockPos.func_177972_a(face);
            if (!(this.field_145850_b.func_180495_p(vecin).func_177230_c() instanceof UpgradeBlock)) continue;
            this.upgrades[((UpgradeBlock)this.field_145850_b.func_180495_p((BlockPos)vecin).func_177230_c()).upgradeType] = true;
        }
    }

    public boolean hasRedstoneSignal() {
        for (EnumFacing enumfacing : EnumFacing.values()) {
            if (!this.field_145850_b.func_175709_b(this.field_174879_c.func_177972_a(enumfacing), enumfacing)) continue;
            return true;
        }
        if (this.field_145850_b.func_175709_b(this.field_174879_c, EnumFacing.DOWN)) {
            return true;
        }
        BlockPos blockpos = this.field_174879_c.func_177984_a();
        for (EnumFacing enumfacing1 : EnumFacing.values()) {
            if (enumfacing1 == EnumFacing.DOWN || !this.field_145850_b.func_175709_b(blockpos.func_177972_a(enumfacing1), enumfacing1)) continue;
            return true;
        }
        return false;
    }

    public int invInsert(IItemHandler itemhandler, ItemStack toBeInserted) {
        for (int i = 0; i < itemhandler.getSlots(); ++i) {
            ItemStack cur = itemhandler.getStackInSlot(i);
            if (cur.func_190926_b()) {
                itemhandler.insertItem(i, toBeInserted, false);
                return 1;
            }
            if (!ItemStack.func_179545_c((ItemStack)toBeInserted, (ItemStack)cur) || cur.func_190916_E() == cur.func_77976_d()) continue;
            if (cur.func_190916_E() + toBeInserted.func_190916_E() <= cur.func_77976_d()) {
                itemhandler.insertItem(i, toBeInserted, false);
                return 1;
            }
            int ammount = cur.func_77976_d() - cur.func_190916_E();
            ItemStack remainder = toBeInserted;
            remainder.func_190918_g(ammount);
            toBeInserted.func_190920_e(ammount);
            this.items.add(remainder);
        }
        return 0;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        if (capability == CapabilityEnergy.ENERGY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)((Object)this);
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)this.tank;
        }
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)this.energy;
        }
        return (T)super.getCapability(capability, facing);
    }

    public int getSlots() {
        return 1;
    }

    public ItemStack getStackInSlot(int slot) {
        if (slot != 0) {
            return ItemStack.field_190927_a;
        }
        int i = 0;
        if (i < this.items.size()) {
            return this.items.get(i);
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        return stack;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        int i = 0;
        if (i < this.items.size()) {
            ItemStack eject = this.items.get(i);
            if (!simulate) {
                this.items.remove(i);
                --i;
            }
            return eject;
        }
        return ItemStack.field_190927_a;
    }

    public int getSlotLimit(int slot) {
        int i = 0;
        if (i < this.items.size()) {
            ItemStack firstStack = this.items.get(i);
            return firstStack.func_77976_d();
        }
        return 64;
    }

    public static enum DigType {
        NORMAL(null, 0),
        SILK(Enchantments.field_185306_r, 1),
        FORTUNE(Enchantments.field_185308_t, 1),
        FORTUNE2(Enchantments.field_185308_t, 2),
        FORTUNE3(Enchantments.field_185308_t, 3),
        SPEED(Enchantments.field_185305_q, 1),
        SPEED2(Enchantments.field_185305_q, 3),
        SPEED3(Enchantments.field_185305_q, 5);

        public Enchantment ench;
        public int level;

        private DigType(Enchantment ench, int level) {
            this.ench = ench;
            this.level = level;
        }

        public int getFortuneModifier() {
            if (this.ench == Enchantments.field_185308_t) {
                return this.level;
            }
            return 0;
        }

        public ItemStack newStack(Item pick) {
            ItemStack stack = new ItemStack(pick);
            if (this.ench != null) {
                stack.func_77966_a(this.ench, this.level);
            }
            return stack;
        }

        public boolean isSilkTouch() {
            return this.ench == Enchantments.field_185306_r;
        }
    }
}

