/*
 * Decompiled with CFR 0.152.
 */
package com.myuki69.enderquarry;

import com.myuki69.enderquarry.TileEnderQuarry;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EnderQuarry
extends Block {
    private static final String UNLOCALIZED_NAME = "enderquarry";

    public EnderQuarry() {
        super(Material.field_151576_e);
        this.func_149663_c(UNLOCALIZED_NAME);
        this.setRegistryName(UNLOCALIZED_NAME);
        this.func_149711_c(5.0f);
        this.func_149647_a(CreativeTabs.field_78028_d);
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity tile;
        if (!world.field_72995_K && (tile = world.func_175625_s(pos)) instanceof TileEnderQuarry) {
            TileEnderQuarry quarry = (TileEnderQuarry)tile;
            if (quarry.finished) {
                player.func_145747_a((ITextComponent)new TextComponentString("Quarry has finished"));
                return true;
            }
            if (quarry.started) {
                int x = (quarry.chunk_x << 4) + quarry.dx;
                int z = (quarry.chunk_z << 4) + quarry.dz;
                int y = quarry.dy;
                if (quarry.hasRedstoneSignal()) {
                    player.func_145747_a((ITextComponent)new TextComponentString("Quarry stopped due to redstone signal!"));
                }
                player.func_145747_a((ITextComponent)new TextComponentString("Stored energy: " + quarry.energy.getEnergyStored() + "/" + quarry.energy.getMaxEnergyStored()));
                player.func_145747_a((ITextComponent)new TextComponentString("Mining at: " + x + ", " + y + ", " + z));
                player.func_145747_a((ITextComponent)new TextComponentString("" + quarry.progress + " blocks scanned."));
                if (quarry.tank.getFluid() != null && quarry.tank.getFluidAmount() > 0) {
                    player.func_145747_a((ITextComponent)new TextComponentString("Stored liquid: " + quarry.tank.getFluid().getLocalizedName() + ": " + quarry.tank.getFluidAmount() + "/" + quarry.tank.getCapacity()));
                } else {
                    player.func_145747_a((ITextComponent)new TextComponentString("Tank empty"));
                }
            } else {
                player.func_145747_a((ITextComponent)new TextComponentString("Analyzing Fence boundary"));
                if (!quarry.checkForMarkers(player)) {
                    player.func_145747_a((ITextComponent)new TextComponentString("Failed to set up quarry"));
                }
            }
        }
        return true;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TileEnderQuarry) {
            ((TileEnderQuarry)tile).checkSurroundings();
        }
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEnderQuarry();
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.SOLID;
    }
}

