/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.zoo.sound;

import com.enderio.core.common.util.NullHelper;
import crazypants.enderio.base.events.ModSoundRegisterEvent;
import crazypants.enderio.base.sound.IModSound;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="enderiozoo")
public enum SoundRegistry implements IModSound
{
    OWL_HOOT(SoundCategory.NEUTRAL, "owl.hootSingle"),
    OWL_HOOT2(SoundCategory.NEUTRAL, "owl.hootDouble"),
    OWL_HURT(SoundCategory.NEUTRAL, "owl.hurt"),
    WOLF_HURT(SoundCategory.HOSTILE, "direwolf.hurt"),
    WOLF_HOWL(SoundCategory.HOSTILE, "direwolf.howl"),
    WOLF_GROWL(SoundCategory.HOSTILE, "direwolf.growl"),
    WOLF_DEATH(SoundCategory.HOSTILE, "direwolf.death");

    @Nonnull
    private final ResourceLocation resourceLocation;
    @Nonnull
    private final SoundCategory soundCategory;
    @Nullable
    private SoundEvent soundEvent = null;

    private SoundRegistry(SoundCategory soundCategory, ResourceLocation resourceLocation) {
        this.soundCategory = soundCategory;
        this.resourceLocation = resourceLocation;
    }

    private SoundRegistry(SoundCategory soundCategory, String name) {
        this(soundCategory, new ResourceLocation("enderio", name));
    }

    @SubscribeEvent
    public static void registerSounds(@Nonnull ModSoundRegisterEvent event) {
        for (SoundRegistry soundRegistry : SoundRegistry.values()) {
            if (SoundEvent.field_187505_a.func_148741_d((Object)soundRegistry.resourceLocation)) {
                soundRegistry.soundEvent = (SoundEvent)event.getRegistry().getValue(soundRegistry.resourceLocation);
                continue;
            }
            SoundEvent soundEvent_nullchecked = soundRegistry.soundEvent = new SoundEvent(soundRegistry.resourceLocation);
            event.getRegistry().register(soundEvent_nullchecked.setRegistryName(soundRegistry.resourceLocation));
        }
    }

    public boolean isValid() {
        return this.soundEvent != null;
    }

    @Nonnull
    public SoundEvent getSoundEvent() {
        return (SoundEvent)NullHelper.notnull((Object)this.soundEvent, (String)"trying to play unregistered sound");
    }

    @Nonnull
    public SoundCategory getSoundCategory() {
        return this.soundCategory;
    }
}

