/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.zoo.entity.ai;

import crazypants.enderio.util.Prep;
import crazypants.enderio.zoo.entity.IEnderZooEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;

public class EntityAIFlyingAttackOnCollide
extends EntityAIBase {
    private EntityCreature attacker;
    private int attackTick;
    private double speedTowardsTarget;
    private boolean longMemory;
    private Path entityPathEntity;
    private Class<? extends Entity> classTarget;
    private int delayCounter;
    private double targetX;
    private double targetY;
    private double targetZ;
    private int failedPathFindingPenalty = 0;
    private boolean canPenalize = false;
    private IEnderZooEntity.Flying flyingMob;

    public EntityAIFlyingAttackOnCollide(IEnderZooEntity.Flying mob, Class<? extends Entity> targetClass, double speedIn, boolean useLongMemory) {
        this(mob, speedIn, useLongMemory);
        this.classTarget = targetClass;
    }

    public EntityAIFlyingAttackOnCollide(IEnderZooEntity.Flying mob, double speedIn, boolean useLongMemory) {
        this.flyingMob = mob;
        this.attacker = mob.asEntityCreature();
        this.speedTowardsTarget = speedIn;
        this.longMemory = useLongMemory;
        this.func_75248_a(3);
    }

    public boolean func_75250_a() {
        EntityLivingBase entitylivingbase = this.attacker.func_70638_az();
        if (entitylivingbase == null) {
            return false;
        }
        if (!entitylivingbase.func_70089_S()) {
            return false;
        }
        if (this.classTarget != null && !this.classTarget.isAssignableFrom(entitylivingbase.getClass())) {
            return false;
        }
        if (this.canPenalize) {
            if (--this.delayCounter <= 0) {
                this.setPathTo(entitylivingbase);
                this.targetX = 4 + this.attacker.func_70681_au().nextInt(7);
                return this.entityPathEntity != null;
            }
            return true;
        }
        this.setPathTo(entitylivingbase);
        return this.entityPathEntity != null;
    }

    private void setPathTo(EntityLivingBase target) {
        Vec3d targPos = target.func_174791_d();
        AxisAlignedBB targBB = target.func_174813_aQ();
        this.entityPathEntity = this.attacker.func_70661_as().func_179680_a(new BlockPos(targPos.field_72450_a, targBB.field_72337_e + 1.0, targPos.field_72449_c));
    }

    public boolean func_75253_b() {
        EntityLivingBase target = this.attacker.func_70638_az();
        if (target == null || !target.func_70089_S()) {
            return false;
        }
        return !this.longMemory ? !this.attacker.func_70661_as().func_75500_f() : this.attacker.func_180485_d(new BlockPos((Entity)target));
    }

    public void func_75249_e() {
        this.flyingMob.getFlyingNavigator().setPath(this.entityPathEntity, this.speedTowardsTarget, true);
        this.delayCounter = 0;
    }

    public void func_75251_c() {
        this.attacker.func_70661_as().func_75499_g();
    }

    public void func_75246_d() {
        EntityLivingBase entitylivingbase = this.attacker.func_70638_az();
        if (entitylivingbase == null) {
            return;
        }
        this.attacker.func_70671_ap().func_75651_a((Entity)entitylivingbase, 30.0f, 30.0f);
        double distToTargSq = this.attacker.func_70092_e(entitylivingbase.field_70165_t, entitylivingbase.func_174813_aQ().field_72338_b, entitylivingbase.field_70161_v);
        double attackRangSq = this.getAttackRangeSq(entitylivingbase);
        --this.delayCounter;
        if ((this.longMemory || this.attacker.func_70635_at().func_75522_a((Entity)entitylivingbase)) && this.delayCounter <= 0 && (this.targetX == 0.0 && this.targetY == 0.0 && this.targetZ == 0.0 || entitylivingbase.func_70092_e(this.targetX, this.targetY, this.targetZ) >= 1.0 || this.attacker.func_70681_au().nextFloat() < 0.05f)) {
            this.targetX = entitylivingbase.field_70165_t;
            this.targetY = entitylivingbase.func_174813_aQ().field_72338_b;
            this.targetZ = entitylivingbase.field_70161_v;
            this.delayCounter = 4 + this.attacker.func_70681_au().nextInt(7);
            if (this.canPenalize) {
                PathPoint finalPathPoint;
                this.targetX += (double)this.failedPathFindingPenalty;
                Path path = this.attacker.func_70661_as().func_75505_d();
                this.failedPathFindingPenalty = path != null ? ((finalPathPoint = path.func_75870_c()) != null && entitylivingbase.func_70092_e((double)finalPathPoint.field_75839_a, (double)finalPathPoint.field_75837_b, (double)finalPathPoint.field_75838_c) < 1.0 ? 0 : (this.failedPathFindingPenalty += 10)) : (this.failedPathFindingPenalty += 10);
            }
            if (distToTargSq > 1024.0) {
                this.delayCounter += 10;
            } else if (distToTargSq > 256.0) {
                this.delayCounter += 5;
            }
            if (!this.flyToAttacker(entitylivingbase)) {
                this.delayCounter += 15;
            }
        }
        this.attackTick = Math.max(this.attackTick - 1, 0);
        if (distToTargSq <= attackRangSq && this.attackTick <= 0) {
            this.attackTick = 20;
            if (Prep.isValid((ItemStack)this.attacker.func_184586_b(EnumHand.MAIN_HAND))) {
                this.attacker.func_184609_a(EnumHand.MAIN_HAND);
            }
            this.attacker.func_70652_k((Entity)entitylivingbase);
        }
    }

    private boolean flyToAttacker(EntityLivingBase targetEnt) {
        AxisAlignedBB targBB = targetEnt.func_174813_aQ();
        return this.flyingMob.getFlyingNavigator().tryFlyToPos(targetEnt.field_70165_t, targBB.field_72337_e + 0.5, targetEnt.field_70161_v, this.speedTowardsTarget);
    }

    protected double getAttackRangeSq(EntityLivingBase attackTarget) {
        return this.attacker.field_70130_N * 2.0f * this.attacker.field_70130_N * 2.0f + attackTarget.field_70130_N;
    }
}

