/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.zoo.entity;

import com.enderio.core.common.util.BlockCoord;
import com.enderio.core.common.util.NullHelper;
import com.enderio.core.common.vecmath.Vector4f;
import crazypants.enderio.base.events.EnderIOLifecycleEvent;
import crazypants.enderio.base.loot.EntityLootHelper;
import crazypants.enderio.base.render.ranged.InfinityParticle;
import crazypants.enderio.zoo.config.ZooConfig;
import crazypants.enderio.zoo.entity.IEnderZooEntity;
import crazypants.enderio.zoo.entity.render.RenderVoidSlime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldEntitySpawner;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber(modid="enderiozoo")
public class EntityVoidSlime
extends EntityMagmaCube
implements IEnderZooEntity.Aggressive {
    @Nonnull
    private static final EntityLiving.SpawnPlacementType ON_BEDROCK = (EntityLiving.SpawnPlacementType)NullHelper.first((Object[])new EntityLiving.SpawnPlacementType[]{EnumHelper.addSpawnPlacementType((String)"ON_BEDROCK", (world, pos) -> pos != null && pos.func_177956_o() < 32 && world.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150357_h && WorldEntitySpawner.func_185331_a((IBlockState)world.func_180495_p(pos)) && WorldEntitySpawner.func_185331_a((IBlockState)world.func_180495_p(pos.func_177984_a())) && (!(world instanceof World) || !((World)world).func_175710_j(pos))), EntityLiving.SpawnPlacementType.ON_GROUND});
    @Nonnull
    public static final String NAME = "voidslime";
    public static final int EGG_BG_COL = 0;
    public static final int EGG_FG_COL = 0xAAAAAA;
    @Nonnull
    private final List<Object> particles = new ArrayList<Object>();
    private int actionDelay = 0;

    @SubscribeEvent
    public static void onEntityRegister(@Nonnull RegistryEvent.Register<EntityEntry> event) {
        LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("enderio", NAME));
        IEnderZooEntity.register(event, NAME, EntityVoidSlime.class, 0, 0xAAAAAA, IEnderZooEntity.MobID.VSLIME);
        EntitySpawnPlacementRegistry.setPlacementType(EntityVoidSlime.class, (EntityLiving.SpawnPlacementType)ON_BEDROCK);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void onPreInit(EnderIOLifecycleEvent.PreInit event) {
        RenderingRegistry.registerEntityRenderingHandler(EntityVoidSlime.class, (IRenderFactory)RenderVoidSlime.FACTORY);
    }

    public EntityVoidSlime(World world) {
        super(world);
        this.func_70799_a(1, false);
    }

    public void func_70799_a(int size, boolean doFullHeal) {
        super.func_70799_a(1, doFullHeal);
        this.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111264_e).func_111128_a((double)((Float)ZooConfig.voidSlimeAttackDamage.get()).floatValue());
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)((Float)ZooConfig.voidSlimeHealth.get()).floatValue());
        this.func_70606_j(this.func_110138_aP());
    }

    public void func_70106_y() {
        this.field_70128_L = true;
    }

    @Nonnull
    protected EnumParticleTypes func_180487_n() {
        return EnumParticleTypes.BLOCK_CRACK;
    }

    protected boolean spawnCustomParticles() {
        int i = this.func_70809_q();
        for (int j = 0; j < i * 8; ++j) {
            float f = this.field_70146_Z.nextFloat() * ((float)Math.PI * 2);
            float f1 = this.field_70146_Z.nextFloat() * 0.5f + 0.5f;
            float f2 = MathHelper.func_76126_a((float)f) * (float)i * 0.5f * f1;
            float f3 = MathHelper.func_76134_b((float)f) * (float)i * 0.5f * f1;
            EnumParticleTypes enumparticletypes = this.func_180487_n();
            double d0 = this.field_70165_t + (double)f2;
            double d1 = this.field_70161_v + (double)f3;
            this.field_70170_p.func_175688_a(enumparticletypes, d0, this.func_174813_aQ().field_72338_b, d1, 0.0, 0.0, 0.0, new int[]{Block.func_176210_f((IBlockState)Blocks.field_150357_h.func_176223_P())});
        }
        return true;
    }

    @Nonnull
    protected EntitySlime func_70802_j() {
        return new EntityVoidSlime(this.field_70170_p);
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return new ResourceLocation("enderio", NAME);
    }

    protected void func_184610_a(boolean wasRecentlyHit, int lootingModifier, @Nonnull DamageSource source) {
        EntityLootHelper.dropLoot((EntityLiving)this, (ResourceLocation)this.func_184647_J(), (DamageSource)source);
        this.func_82160_b(wasRecentlyHit, lootingModifier);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b() {
        int j;
        int i = MathHelper.func_76128_c((double)this.field_70165_t);
        if (!this.field_70170_p.func_175623_d(new BlockPos(i, 0, j = MathHelper.func_76128_c((double)this.field_70161_v)))) {
            double d0 = (this.func_174813_aQ().field_72337_e - this.func_174813_aQ().field_72338_b) * 0.66;
            int k = MathHelper.func_76128_c((double)(this.field_70163_u - this.func_70033_W() + d0));
            return this.field_70170_p.func_175626_b(new BlockPos(i, k, j), 0);
        }
        return 0;
    }

    public float func_70013_c() {
        int j;
        int i = MathHelper.func_76128_c((double)this.field_70165_t);
        if (!this.field_70170_p.func_175623_d(new BlockPos(i, 0, j = MathHelper.func_76128_c((double)this.field_70161_v)))) {
            double d0 = (this.func_174813_aQ().field_72337_e - this.func_174813_aQ().field_72338_b) * 0.66;
            int k = MathHelper.func_76128_c((double)(this.field_70163_u - this.func_70033_W() + d0));
            return this.field_70170_p.func_175724_o(new BlockPos(i, k, j));
        }
        return 0.0f;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
    }

    protected int func_70805_n() {
        return (int)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
    }

    protected void func_70105_a(float p_70105_1_, float p_70105_2_) {
        super.func_70105_a(1.0f, 1.0f);
    }

    public void func_70100_b_(@Nonnull EntityPlayer player) {
        if (this.func_70685_l((Entity)player) && player.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)this.func_70805_n())) {
            this.func_184185_a(SoundEvents.field_187870_fk, 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70729_aU) {
            if (this.field_70170_p.field_72995_K) {
                this.onLivingUpdateClient();
            } else {
                this.onLivingUpdateServer();
            }
        }
    }

    private void onLivingUpdateServer() {
        if (this.actionDelay-- <= 0) {
            for (EntityPlayer player : this.getClosestPlayers(((Integer)ZooConfig.voidSlimeRange.get()).intValue())) {
                player.func_70690_d((PotionEffect)new BlindEffect());
            }
            this.actionDelay = (int)(20.0f * (0.5f + 0.5f * this.field_70146_Z.nextFloat()));
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void onLivingUpdateClient() {
        if (this.actionDelay-- <= 0) {
            Iterator<Object> i = this.particles.iterator();
            while (i.hasNext()) {
                if (((InfinityParticle)i.next()).func_187113_k()) continue;
                i.remove();
            }
            if (this.particles.size() < 10) {
                float offsetX = -5.0f + 10.0f * this.field_70146_Z.nextFloat();
                float offsetY = -5.0f + 10.0f * this.field_70146_Z.nextFloat();
                float offsetZ = -5.0f + 10.0f * this.field_70146_Z.nextFloat();
                float maxSize = this.field_70146_Z.nextFloat() * (this.field_70146_Z.nextBoolean() ? (float)(2 * (Integer)ZooConfig.voidSlimeRange.get()) + 0.1f : 3.9f);
                float color = this.field_70146_Z.nextBoolean() ? 0.0f : this.field_70146_Z.nextFloat() / 10.0f;
                InfinityParticle particle = new InfinityParticle(this.field_70170_p, BlockCoord.get((Entity)this), new Vector4f(color, color, color, 1.0f), new Vector4f(offsetX, offsetY, offsetZ, maxSize));
                particle.func_187114_a(200);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)particle);
                this.particles.add(particle);
                this.actionDelay = (int)(20.0f * (0.5f + 0.5f * this.field_70146_Z.nextFloat()));
            }
        }
    }

    public List<EntityPlayer> getClosestPlayers(double distance) {
        List<EntityPlayer> entityplayers = null;
        double distanceSq = distance * distance;
        for (EntityPlayer entityplayer : this.field_70170_p.field_73010_i) {
            if (!EntitySelectors.field_180132_d.apply((Object)entityplayer) || !(distance < 0.0) && !(entityplayer.func_70092_e(this.field_70165_t, this.field_70163_u, this.field_70161_v) < distanceSq)) continue;
            if (entityplayers == null) {
                entityplayers = new ArrayList<EntityPlayer>();
            }
            entityplayers.add(entityplayer);
        }
        return entityplayers != null ? entityplayers : Collections.emptyList();
    }

    private class BlindEffect
    extends PotionEffect {
        private boolean combined;

        public BlindEffect() {
            super(MobEffects.field_76440_q, 100, 0, true, false);
            this.combined = false;
        }

        public boolean func_76455_a(@Nonnull EntityLivingBase entityplayer) {
            if (this.combined || !EntityVoidSlime.this.field_70729_aU && entityplayer.func_70092_e(EntityVoidSlime.this.field_70165_t, EntityVoidSlime.this.field_70163_u, EntityVoidSlime.this.field_70161_v) < (double)((Integer)ZooConfig.voidSlimeRange.get() * (Integer)ZooConfig.voidSlimeRange.get())) {
                return super.func_76455_a(entityplayer);
            }
            return false;
        }

        public void func_76452_a(@Nonnull PotionEffect other) {
            if (!(other instanceof BlindEffect)) {
                this.combined = true;
            }
            super.func_76452_a(other);
        }
    }
}

