/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.vacuum.chest;

import com.enderio.core.api.client.gui.IGuiScreen;
import com.enderio.core.api.client.render.IWidgetIcon;
import com.enderio.core.client.gui.button.IconButton;
import com.enderio.core.client.gui.button.MultiIconButton;
import com.enderio.core.client.gui.button.ToggleButton;
import com.enderio.core.client.gui.widget.GhostSlot;
import com.enderio.core.client.gui.widget.GuiToolTip;
import com.enderio.core.client.render.ColorUtil;
import com.enderio.core.client.render.EnderWidget;
import crazypants.enderio.base.gui.GuiContainerBaseEIO;
import crazypants.enderio.base.gui.IconEIO;
import crazypants.enderio.base.gui.RedstoneModeButton;
import crazypants.enderio.base.lang.Lang;
import crazypants.enderio.machines.machine.vacuum.chest.ContainerVacuumChest;
import crazypants.enderio.machines.machine.vacuum.chest.ContainerVacuumChestProxy;
import crazypants.enderio.machines.machine.vacuum.chest.PacketVaccumChest;
import crazypants.enderio.machines.machine.vacuum.chest.TileVacuumChest;
import crazypants.enderio.machines.network.PacketHandler;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiVacuumChest
extends GuiContainerBaseEIO<TileVacuumChest>
implements ContainerVacuumChestProxy {
    private static final int RANGE_LEFT = 145;
    private static final int RANGE_TOP = 86;
    private static final int RANGE_WIDTH = 16;
    private static final int FILTER_LEFT = 29;
    private static final int FILTER_TOP = 85;
    private static final int ID_RANGE_UP = 4711;
    private static final int ID_RANGE_DOWN = 4712;
    private static final int ID_REDSTONE = 4715;
    private static final int ID_OPEN_FILTER = 4713;
    @Nonnull
    private final GuiToolTip rangeTooltip;
    @Nonnull
    private final MultiIconButton rangeUpB;
    @Nonnull
    private final MultiIconButton rangeDownB;
    @Nonnull
    private final RedstoneModeButton<TileVacuumChest> rsB;
    @Nonnull
    private final String headerChest;
    @Nonnull
    private final String headerFilter;
    @Nonnull
    private final String headerRange;
    @Nonnull
    private final String headerInventory;
    @Nonnull
    private final ToggleButton showRangeB;
    @Nonnull
    private final IconButton openFilterGuiB;

    public GuiVacuumChest(@Nonnull InventoryPlayer inventory, @Nonnull TileVacuumChest te) {
        super(te, (Container)new ContainerVacuumChest(inventory, te), "vacuum_chest");
        this.field_147000_g = 206;
        int x = 145;
        int y = 86;
        this.rangeTooltip = new GuiToolTip(new Rectangle(x, y, 16, 16), new String[]{crazypants.enderio.machines.lang.Lang.GUI_VACUUM_RANGE_TOOLTIP.get()});
        this.rangeUpB = MultiIconButton.createAddButton((IGuiScreen)this, (int)4711, (int)(x += 16), (int)y);
        this.rangeDownB = MultiIconButton.createMinusButton((IGuiScreen)this, (int)4712, (int)x, (int)(y += 8));
        x = this.field_146999_f - 16 - 7;
        y = 104;
        this.rsB = new RedstoneModeButton<TileVacuumChest>((IGuiScreen)this, 4715, x, y, te);
        this.showRangeB = new ToggleButton((IGuiScreen)this, -1, x -= 18, y, (IWidgetIcon)IconEIO.SHOW_RANGE, (IWidgetIcon)IconEIO.HIDE_RANGE);
        this.showRangeB.setSize(16, 16);
        this.addToolTip(new GuiToolTip(this.showRangeB.getBounds(), new String[]{"null"}){

            @Nonnull
            public List<String> getToolTipText() {
                return Collections.singletonList((GuiVacuumChest.this.showRangeB.isSelected() ? crazypants.enderio.machines.lang.Lang.GUI_HIDE_RANGE : crazypants.enderio.machines.lang.Lang.GUI_SHOW_RANGE).get());
            }
        });
        this.openFilterGuiB = new IconButton((IGuiScreen)this, 4713, 29, 85, (IWidgetIcon)IconEIO.GEAR_LIGHT);
        this.openFilterGuiB.setToolTip(new String[]{Lang.GUI_EDIT_ITEM_FILTER.get()});
        this.headerChest = crazypants.enderio.machines.lang.Lang.GUI_VACUUM_CHEST.get();
        this.headerFilter = crazypants.enderio.machines.lang.Lang.GUI_VACUUM_FILTER.get();
        this.headerRange = crazypants.enderio.machines.lang.Lang.GUI_VACUUM_RANGE.get();
        this.headerInventory = crazypants.enderio.machines.lang.Lang.GUI_VACUUM_INVENTORY.get();
        ((ContainerVacuumChest)this.field_147002_h).setFilterChangedCB(new Runnable(){

            @Override
            public void run() {
                GuiVacuumChest.this.filterChanged();
            }
        });
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.openFilterGuiB.onGuiInit();
        this.rangeUpB.onGuiInit();
        this.rangeDownB.onGuiInit();
        this.rsB.onGuiInit();
        this.addToolTip(this.rangeTooltip);
        this.showRangeB.onGuiInit();
        this.showRangeB.setSelected(((TileVacuumChest)this.getOwner()).isShowingRange());
        this.filterChanged();
        ((ContainerVacuumChest)this.field_147002_h).createGhostSlots((List<GhostSlot>)this.getGhostSlotHandler().getGhostSlots());
    }

    public void func_146284_a(@Nonnull GuiButton guiButton) {
        if (guiButton == this.showRangeB) {
            ((TileVacuumChest)this.getOwner()).setShowRange(this.showRangeB.isSelected());
            return;
        }
        switch (guiButton.field_146127_k) {
            case 4711: {
                this.setRange((int)(((TileVacuumChest)this.getOwner()).getRange() + 1.0f));
                break;
            }
            case 4712: {
                this.setRange((int)(((TileVacuumChest)this.getOwner()).getRange() - 1.0f));
                break;
            }
            case 4713: {
                this.doOpenFilterGui(0);
            }
        }
    }

    private void setRange(int range) {
        PacketHandler.INSTANCE.sendToServer((IMessage)PacketVaccumChest.setRange((TileVacuumChest)this.getOwner(), range));
    }

    void filterChanged() {
        if (((TileVacuumChest)this.getOwner()).hasItemFilter()) {
            this.openFilterGuiB.setIsVisible(true);
        } else {
            this.openFilterGuiB.setIsVisible(false);
        }
    }

    protected void func_146976_a(float par1, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.bindGuiTexture();
        int sx = (this.field_146294_l - this.field_146999_f) / 2;
        int sy = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(sx, sy, 0, 0, this.field_146999_f, this.field_147000_g);
        int headerColor = 0x404040;
        FontRenderer fr = this.getFontRenderer();
        fr.func_78276_b(this.headerChest, sx + 7, sy + 6, headerColor);
        fr.func_78276_b(this.headerFilter, sx + 7, sy + 74, headerColor);
        fr.func_78276_b(this.headerRange, sx + this.field_146999_f - 7 - fr.func_78256_a(this.headerRange), sy + 74, headerColor);
        fr.func_78276_b(this.headerInventory, sx + 7, sy + 111, headerColor);
        IconEIO.map.render((IWidgetIcon)EnderWidget.BUTTON_DOWN, (double)(sx + 145), (double)(sy + 86), 16.0, 16.0, 0.0, true);
        String str = Integer.toString((int)((TileVacuumChest)this.getOwner()).getRange());
        int sw = fr.func_78256_a(str);
        fr.func_78276_b(str, sx + 145 + 16 - sw - 5, sy + 86 + 5, ColorUtil.getRGB((Color)Color.black));
        super.func_146976_a(par1, mouseX, mouseY);
    }
}

