/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.handler.darksteel.gui;

import crazypants.enderio.base.handler.darksteel.gui.ISlotSelector;
import crazypants.enderio.util.Prep;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public enum SlotSelector implements ISlotSelector
{
    MAIN(1, EntityEquipmentSlot.MAINHAND),
    HEAD(2, EntityEquipmentSlot.HEAD),
    CHEST(3, EntityEquipmentSlot.CHEST),
    LEGS(4, EntityEquipmentSlot.LEGS),
    FEET(5, EntityEquipmentSlot.FEET),
    OFFH(6, EntityEquipmentSlot.OFFHAND);

    public static final ISlotSelector ANVIL;
    private static final String INTERNAL_LOGIC_ERROR = "Internal Logic Error";
    private final EntityEquipmentSlot slot;
    private final int tabOrder;

    public static SlotSelector fromEntityEquipmentSlot(EntityEquipmentSlot slot) {
        for (SlotSelector ss : SlotSelector.values()) {
            if (ss.slot != slot) continue;
            return ss;
        }
        throw new RuntimeException("No such EntityEquipmentSlot " + slot);
    }

    private SlotSelector(int tabOrder, EntityEquipmentSlot slot) {
        this.tabOrder = tabOrder;
        this.slot = slot;
    }

    @Override
    public boolean isAnvil() {
        return false;
    }

    @Override
    public boolean isItem() {
        return false;
    }

    @Override
    public boolean isSlot() {
        return true;
    }

    @Override
    @Nonnull
    public EntityEquipmentSlot getSlot() {
        return this.slot;
    }

    @Override
    public int getTabOrder() {
        return this.tabOrder;
    }

    @Override
    @Nonnull
    public ItemStack getItem(@Nonnull EntityPlayer player) {
        return player.func_184582_a(this.slot);
    }

    @Override
    @Nonnull
    public Slot setContainerSlot(@Nonnull Slot containerSlot) {
        throw new RuntimeException(INTERNAL_LOGIC_ERROR);
    }

    @Override
    @Nonnull
    public Slot getContainerSlot() {
        throw new RuntimeException(INTERNAL_LOGIC_ERROR);
    }

    static {
        ANVIL = new ISlotSelector(){

            @Override
            public boolean isAnvil() {
                return true;
            }

            @Override
            public boolean isItem() {
                return false;
            }

            @Override
            public boolean isSlot() {
                return false;
            }

            @Override
            @Nonnull
            public EntityEquipmentSlot getSlot() {
                throw new RuntimeException(SlotSelector.INTERNAL_LOGIC_ERROR);
            }

            @Override
            public int getTabOrder() {
                return 0;
            }

            @Override
            @Nonnull
            public ItemStack getItem(@Nonnull EntityPlayer player) {
                return new ItemStack(Blocks.field_150467_bQ);
            }

            @Override
            @Nonnull
            public Slot setContainerSlot(@Nonnull Slot containerSlot) {
                throw new RuntimeException(SlotSelector.INTERNAL_LOGIC_ERROR);
            }

            @Override
            public Slot getContainerSlot() {
                throw new RuntimeException(SlotSelector.INTERNAL_LOGIC_ERROR);
            }
        };
    }

    public static class RawItem
    extends SlotItem {
        private final ItemStack item;

        public RawItem(ItemStack item) {
            this.item = item;
        }

        @Override
        @Nonnull
        public Slot setContainerSlot(@Nonnull Slot containerSlot) {
            throw new RuntimeException(SlotSelector.INTERNAL_LOGIC_ERROR);
        }

        @Override
        public boolean isAnvil() {
            return false;
        }

        @Override
        public boolean isItem() {
            return true;
        }

        @Override
        public boolean isSlot() {
            return false;
        }

        @Override
        @Nonnull
        public EntityEquipmentSlot getSlot() {
            throw new RuntimeException(SlotSelector.INTERNAL_LOGIC_ERROR);
        }

        @Override
        public int getTabOrder() {
            return 7;
        }

        @Override
        @Nonnull
        public ItemStack getItem(@Nonnull EntityPlayer player) {
            return this.item;
        }

        @Override
        @Nullable
        public Slot getContainerSlot() {
            throw new RuntimeException(SlotSelector.INTERNAL_LOGIC_ERROR);
        }
    }

    public static class SlotItem
    implements ISlotSelector {
        @Nullable
        private Slot containerSlot = null;

        @Override
        @Nonnull
        public Slot setContainerSlot(@Nonnull Slot containerSlot) {
            this.containerSlot = containerSlot;
            return this.containerSlot;
        }

        @Override
        public boolean isAnvil() {
            return false;
        }

        @Override
        public boolean isItem() {
            return true;
        }

        @Override
        public boolean isSlot() {
            return false;
        }

        @Override
        @Nonnull
        public EntityEquipmentSlot getSlot() {
            throw new RuntimeException(SlotSelector.INTERNAL_LOGIC_ERROR);
        }

        @Override
        public int getTabOrder() {
            return 7;
        }

        @Override
        @Nonnull
        public ItemStack getItem(@Nonnull EntityPlayer player) {
            return this.containerSlot != null ? this.containerSlot.func_75211_c() : Prep.getEmpty();
        }

        @Override
        @Nullable
        public Slot getContainerSlot() {
            return this.containerSlot;
        }
    }
}

