/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base;

import crazypants.enderio.base.config.config.DiagnosticsConfig;
import crazypants.enderio.base.events.EnderIOLifecycleEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="enderio")
public final class Log {
    private static boolean inDev = System.getProperty("INDEV") != null;
    private static boolean suppressDebugMessages = false;
    public static final Logger LOGGER = LogManager.getLogger((String)"enderio");

    public static void warn(Object ... msg) {
        LOGGER.warn(() -> Log.join(msg));
    }

    public static void error(Object ... msg) {
        LOGGER.error(() -> Log.join(msg));
    }

    public static void info(Object ... msg) {
        LOGGER.info(() -> Log.join(msg));
    }

    public static void debug(Object ... msg) {
        if (inDev) {
            LOGGER.info(() -> "INDEV: " + Log.join(msg));
        } else if (!suppressDebugMessages) {
            LOGGER.debug(() -> Log.join(msg));
        }
    }

    public static void livetraceNBT(Object ... msg) {
        if (((Boolean)DiagnosticsConfig.debugTraceNBTActivityExtremelyDetailed.get()).booleanValue()) {
            LOGGER.info(Log.join("", msg));
        }
    }

    public static String join(CharSequence delimiter, Object ... elements) {
        StringBuilder joiner = new StringBuilder();
        for (Object cs : elements) {
            if (joiner.length() != 0) {
                joiner.append(delimiter);
            }
            joiner.append(cs);
        }
        return joiner.toString();
    }

    public static String join(Object ... elements) {
        StringBuilder joiner = new StringBuilder();
        for (Object cs : elements) {
            joiner.append(cs);
        }
        return joiner.toString();
    }

    private Log() {
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void preInit(EnderIOLifecycleEvent.Config.Post event) {
        suppressDebugMessages = (Boolean)DiagnosticsConfig.debugSuppressDebugMessages.get();
        inDev |= ((Boolean)DiagnosticsConfig.debugUpgradeDebugMessagesToInfo.get()).booleanValue();
        if (LOGGER.isDebugEnabled()) {
            if (((Boolean)DiagnosticsConfig.debugComplainAboutForgeLogging.get()).booleanValue()) {
                Logger temp = LogManager.getLogger((String)"");
                temp.warn("========================================================");
                temp.warn("== Forge Debug Logging is ENABLED ======================");
                temp.warn("========================================================");
                temp.warn("== This WILL slow down the game, so we recommend you  ==");
                temp.warn("== disable it unless you need it. See:                ==");
                temp.warn("== https://github.com/MinecraftForge/MinecraftForge/issues/6271");
                temp.warn("========================================================");
            }
            if (suppressDebugMessages) {
                Log.info("========================================================");
                Log.info("== Ender IO Debug Logging is DISABLED ==================");
                Log.info("========================================================");
                Log.info("== This will not slow down the game, but you may miss ==");
                Log.info("== out on information needed to diagnose issues. For  ==");
                Log.info("== normal operation this is fine.                     ==");
                Log.info("========================================================");
            } else {
                Log.warn("========================================================");
                Log.warn("== Ender IO Debug Logging is ENABLED ===================");
                Log.warn("========================================================");
                Log.warn("== This WILL slow down the game, so we recommend you  ==");
                Log.warn("== disable it unless you need it.                     ==");
                Log.warn("========================================================");
            }
        } else if (!suppressDebugMessages) {
            Log.warn("========================================================");
            Log.warn("== Forge Debug Logging is DISABLED but =================");
            Log.warn("== Ender IO Debug Logging is ENABLED ===================");
            Log.warn("========================================================");
            Log.warn("== This means that Forge will throw away those log    ==");
            Log.warn("== messages you asked Ender IO to generate.           ==");
            Log.warn("========================================================");
        }
    }

    public static boolean isInDev() {
        return inDev;
    }
}

