/*
 * Decompiled with CFR 0.152.
 */
package net.foxmcloud.draconicadditions.handlers;

import com.brandon3055.brandonscore.registry.ModFeatureParser;
import com.brandon3055.brandonscore.utils.ItemNBTHelper;
import com.brandon3055.draconicevolution.entity.EntityChaosGuardian;
import com.brandon3055.draconicevolution.handlers.CustomArmorHandler;
import com.brandon3055.draconicevolution.helpers.ResourceHelperDE;
import net.foxmcloud.draconicadditions.CommonMethods;
import net.foxmcloud.draconicadditions.DAFeatures;
import net.foxmcloud.draconicadditions.capabilities.ChaosInBloodProvider;
import net.foxmcloud.draconicadditions.capabilities.IChaosInBlood;
import net.foxmcloud.draconicadditions.entity.EntityChaosHeart;
import net.foxmcloud.draconicadditions.items.tools.ChaosContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class DAEventHandler {
    @SubscribeEvent(priority=EventPriority.LOW)
    public void getBreakSpeed(PlayerEvent.BreakSpeed event) {
        if (event.getEntityPlayer() != null) {
            float newDigSpeed = event.getOriginalSpeed();
            CustomArmorHandler.ArmorSummery summery = new CustomArmorHandler.ArmorSummery().getSummery(event.getEntityPlayer());
            if (summery == null) {
                return;
            }
            if (event.getEntityPlayer().func_70055_a(Material.field_151586_h) && ((ItemStack)summery.armorStacks.get(3)).func_77973_b() == DAFeatures.chaoticHelm) {
                newDigSpeed *= 5.0f;
            }
            if (!event.getEntityPlayer().field_70122_E && ((ItemStack)summery.armorStacks.get(2)).func_77973_b() == DAFeatures.chaoticChest) {
                newDigSpeed *= 5.0f;
            }
            if (newDigSpeed != event.getOriginalSpeed()) {
                event.setNewSpeed(newDigSpeed);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent(priority=EventPriority.HIGH)
    public void guiMouse(GuiScreenEvent.MouseInputEvent.Pre event) {
        ItemStack stack;
        GuiContainer inventory;
        Slot slot;
        if (event.getGui() instanceof GuiContainer && (slot = (inventory = (GuiContainer)event.getGui()).getSlotUnderMouse()) != null && (stack = slot.func_75211_c()) != null) {
            EntityPlayerSP player = event.getGui().field_146297_k.field_71439_g;
            if (stack.func_77973_b() instanceof ChaosContainer && !player.func_184812_l_()) {
                event.setCanceled(((ChaosContainer)stack.func_77973_b()).getChaos(stack) > 0);
            } else if (stack.func_77973_b() == DAFeatures.chaoticChest) {
                event.setCanceled(ItemNBTHelper.getBoolean((ItemStack)stack, (String)"injecting", (boolean)false) || ItemNBTHelper.getBoolean((ItemStack)stack, (String)"bloodIsChaos", (boolean)false));
            }
        }
    }

    @SubscribeEvent
    public void onDropEvent(LivingDropsEvent event) {
        if (!event.getEntity().field_70170_p.field_72995_K && event.getEntity() instanceof EntityChaosGuardian && ModFeatureParser.isEnabled((Object)DAFeatures.chaosHeart)) {
            EntityChaosHeart heart = new EntityChaosHeart(event.getEntity().field_70170_p, event.getEntity().field_70165_t, event.getEntity().field_70163_u, event.getEntity().field_70161_v);
            event.getEntity().field_70170_p.func_72838_d((Entity)heart);
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        EntityPlayer player = event.player;
        IChaosInBlood pCap = (IChaosInBlood)player.getCapability(ChaosInBloodProvider.PLAYER_CAP, null);
        if (pCap != null && player.func_70089_S()) {
            Potion wither = Potion.func_180142_b((String)"wither");
            Potion regen = Potion.func_180142_b((String)"regeneration");
            Potion resistance = Potion.func_180142_b((String)"resistance");
            Potion strength = Potion.func_180142_b((String)"strength");
            if (pCap.getChaos() > 0.0f) {
                float chaos = pCap.getChaos();
                float damageAbsorbed = CommonMethods.subtractShielding(player, chaos, 0.075f, 0.2f);
                if (event.side == Side.CLIENT) {
                    player.func_70690_d(new PotionEffect(wither, 2, 0, false, false));
                    player.func_70690_d(new PotionEffect(regen, 2, 0, false, false));
                }
                player.func_70690_d(new PotionEffect(resistance, 2, 3, false, false));
                player.func_70690_d(new PotionEffect(strength, 2, (int)chaos, false, false));
                if ((double)damageAbsorbed < (double)chaos - 0.1 && !player.func_184812_l_()) {
                    player.func_70097_a(CommonMethods.chaosBurst, 1000.0f);
                }
                if (player.func_110143_aJ() > 0.0f) {
                    player.func_70606_j(chaos);
                }
            } else if (!pCap.hasChaos() && pCap.hadChaosLastUpdate()) {
                if (event.side == Side.CLIENT) {
                    player.func_184589_d(regen);
                    player.func_184589_d(wither);
                    player.func_184589_d(resistance);
                    player.func_184589_d(strength);
                } else {
                    player.func_70674_bp();
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onPlayerRightClickEntity(PlayerInteractEvent.EntityInteract event) {
        float damageToDeal;
        EntityLiving target;
        boolean wasDamaged;
        if (event.getItemStack().func_77973_b() instanceof ChaosContainer && ((ChaosContainer)event.getItemStack().func_77973_b()).onLeftClickEntity(event.getItemStack(), event.getEntityPlayer(), event.getTarget())) {
            return;
        }
        float chaosDamageRatio = 10.0f;
        EntityPlayer player = event.getEntityPlayer();
        IChaosInBlood pCap = (IChaosInBlood)player.getCapability(ChaosInBloodProvider.PLAYER_CAP, null);
        if (pCap != null && player.func_70089_S() && pCap.getChaos() > 0.0f && event.getTarget() instanceof EntityLiving && (wasDamaged = (target = (EntityLiving)event.getTarget()).func_70097_a(CommonMethods.chaosBurst, damageToDeal = Math.min(target.func_110143_aJ(), pCap.getChaos() * chaosDamageRatio)))) {
            pCap.removeChaos(damageToDeal / chaosDamageRatio);
            CommonMethods.explodeEntity(target.func_180425_c(), target.field_70170_p);
        }
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone event) {
        if (!event.isWasDeath()) {
            EntityPlayer player = event.getEntityPlayer();
            IChaosInBlood newCap = (IChaosInBlood)player.getCapability(ChaosInBloodProvider.PLAYER_CAP, null);
            IChaosInBlood oldCap = (IChaosInBlood)event.getOriginal().getCapability(ChaosInBloodProvider.PLAYER_CAP, null);
            newCap.setChaos(oldCap.getChaos());
        }
    }

    @SubscribeEvent
    public void onEntityConstructing(AttachCapabilitiesEvent<Entity> e) {
        Entity obj = (Entity)e.getObject();
        if (obj instanceof EntityPlayer && !(obj instanceof FakePlayer)) {
            EntityPlayer player = (EntityPlayer)obj;
            e.addCapability(ResourceHelperDE.getResourceRAW((String)"draconicadditions:chaos_in_blood"), (ICapabilityProvider)new ChaosInBloodProvider());
        }
    }
}

