/*
 * Decompiled with CFR 0.152.
 */
package com.ezrol.terry.minecraft.defaultworldgenerator.gui;

import com.ezrol.terry.minecraft.defaultworldgenerator.DefaultWorldGenerator;
import com.ezrol.terry.minecraft.defaultworldgenerator.config.BooleanTypeNode;
import com.ezrol.terry.minecraft.defaultworldgenerator.config.QuadStateTypeNode;
import com.ezrol.terry.minecraft.defaultworldgenerator.config.StringTypeNode;
import com.ezrol.terry.minecraft.defaultworldgenerator.config.WorldTypeNode;
import com.ezrol.terry.minecraft.defaultworldgenerator.gui.GuiReflectHelper;
import com.ezrol.terry.minecraft.defaultworldgenerator.lib.Log;
import java.io.IOException;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiCreateWorld;
import net.minecraft.client.gui.GuiLabel;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.resources.I18n;
import net.minecraft.world.WorldType;

public class GuiCreateCustomWorld
extends GuiCreateWorld {
    private WorldTypeNode presetData;
    private boolean cfgLockWorldGenerator;

    public GuiCreateCustomWorld(GuiScreen screen, WorldTypeNode type) {
        super(screen);
        this.presetData = type;
        this.field_146334_a = ((StringTypeNode)this.presetData.getField(WorldTypeNode.Fields.CUSTOMIZATION_STRING)).getValue();
        this.cfgLockWorldGenerator = ((BooleanTypeNode)this.presetData.getField(WorldTypeNode.Fields.LOCK_WORLD_TYPE)).getValue();
        try {
            QuadStateTypeNode.States bonusChest;
            String cfgName;
            int WorldGenerator = 0;
            String generatorName = ((StringTypeNode)this.presetData.getField(WorldTypeNode.Fields.WORLD_GENERATOR)).getValue();
            for (int i = 0; i < WorldType.field_77139_a.length; ++i) {
                if (WorldType.field_77139_a[i] == null || !WorldType.field_77139_a[i].func_77126_d() || !WorldType.field_77139_a[i].func_77127_a().equalsIgnoreCase(generatorName)) continue;
                WorldGenerator = WorldType.field_77139_a[i].func_82747_f();
                Log.info("Changed world type to " + WorldType.field_77139_a[i].func_77127_a());
            }
            GuiReflectHelper.selectedIndex.setInt((Object)this, WorldGenerator);
            String cfgSeed = ((StringTypeNode)this.presetData.getField(WorldTypeNode.Fields.SEED)).getValue();
            if (!cfgSeed.equals("")) {
                GuiReflectHelper.worldSeed.set((Object)this, cfgSeed);
            }
            if (!(cfgName = ((StringTypeNode)this.presetData.getField(WorldTypeNode.Fields.CONFIGURATION_NAME)).getValue()).equals("")) {
                GuiReflectHelper.worldName.set((Object)this, I18n.func_135052_a((String)"defaultworldgenerator-port.newworld.gui.name", (Object[])new Object[]{cfgName}));
            }
            if ((bonusChest = ((QuadStateTypeNode)this.presetData.getField(WorldTypeNode.Fields.BONUS_CHEST_STATE)).getValue()) == QuadStateTypeNode.States.STATE_ENABLED || bonusChest == QuadStateTypeNode.States.STATE_FORCED) {
                GuiReflectHelper.bonusChestEnabled.setBoolean((Object)this, true);
            } else {
                GuiReflectHelper.bonusChestEnabled.setBoolean((Object)this, false);
            }
            QuadStateTypeNode.States structures = ((QuadStateTypeNode)this.presetData.getField(WorldTypeNode.Fields.STRUCTURE_STATE)).getValue();
            if (structures == QuadStateTypeNode.States.STATE_ENABLED || structures == QuadStateTypeNode.States.STATE_FORCED) {
                GuiReflectHelper.generateStructuresEnabled.setBoolean((Object)this, true);
            } else {
                GuiReflectHelper.generateStructuresEnabled.setBoolean((Object)this, false);
            }
        }
        catch (Exception ex) {
            Log.fatal("Fatal Error:");
            Log.fatal(ex);
        }
    }

    private void hideWorldConfig() {
        try {
            QuadStateTypeNode.States structures;
            QuadStateTypeNode.States bonusChest;
            if (this.cfgLockWorldGenerator) {
                ((GuiButton)GuiReflectHelper.btnMapType.get((Object)((Object)this))).field_146125_m = false;
                ((GuiButton)GuiReflectHelper.btnCustomizeType.get((Object)((Object)this))).field_146125_m = false;
                ((GuiButton)GuiReflectHelper.btnMapFeatures.get((Object)((Object)this))).field_146128_h = this.field_146294_l / 2 - 75;
                if (!((StringTypeNode)this.presetData.getField(WorldTypeNode.Fields.SEED)).getValue().equals("")) {
                    ((GuiTextField)GuiReflectHelper.worldSeedField.get((Object)this)).func_146184_c(false);
                }
            }
            if ((bonusChest = ((QuadStateTypeNode)this.presetData.getField(WorldTypeNode.Fields.BONUS_CHEST_STATE)).getValue()) == QuadStateTypeNode.States.STATE_BLOCKED || bonusChest == QuadStateTypeNode.States.STATE_FORCED) {
                ((GuiButton)GuiReflectHelper.btnBonusItems.get((Object)((Object)this))).field_146124_l = false;
            }
            if ((structures = ((QuadStateTypeNode)this.presetData.getField(WorldTypeNode.Fields.STRUCTURE_STATE)).getValue()) == QuadStateTypeNode.States.STATE_BLOCKED || structures == QuadStateTypeNode.States.STATE_FORCED) {
                ((GuiButton)GuiReflectHelper.btnMapFeatures.get((Object)((Object)this))).field_146124_l = false;
            }
        }
        catch (Exception ex) {
            Log.fatal("Error Hiding Buttons:");
            Log.fatal(ex);
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        try {
            GuiReflectHelper.updateDisplayState.invoke((Object)this, new Object[0]);
        }
        catch (Exception ex) {
            Log.fatal("Fatal Error:");
            Log.fatal(ex);
        }
        this.hideWorldConfig();
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        this.hideWorldConfig();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        if (!this.cfgLockWorldGenerator) {
            super.func_73863_a(mouseX, mouseY, partialTicks);
            return;
        }
        try {
            if (!GuiReflectHelper.inMoreWorldOptionsDisplay.getBoolean((Object)this)) {
                super.func_73863_a(mouseX, mouseY, partialTicks);
                return;
            }
            this.func_146276_q_();
            this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"selectWorld.create", (Object[])new Object[0]), this.field_146294_l / 2, 20, -1);
            this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)"selectWorld.enterSeed", (Object[])new Object[0]), this.field_146294_l / 2 - 100, 47, -6250336);
            this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)"selectWorld.seedInfo", (Object[])new Object[0]), this.field_146294_l / 2 - 100, 85, -6250336);
            if (((GuiButton)GuiReflectHelper.btnMapFeatures.get((Object)((Object)this))).field_146125_m) {
                this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)"selectWorld.mapFeatures.info", (Object[])new Object[0]), this.field_146294_l / 2 - 70, 122, -6250336);
            }
            if (((GuiButton)GuiReflectHelper.btnAllowCommands.get((Object)((Object)this))).field_146125_m) {
                this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)"selectWorld.allowCommands.info", (Object[])new Object[0]), this.field_146294_l / 2 - 150, 172, -6250336);
            }
            ((GuiTextField)GuiReflectHelper.worldSeedField.get((Object)this)).func_146194_f();
            for (GuiButton aButtonList : this.field_146292_n) {
                aButtonList.func_191745_a(this.field_146297_k, mouseX, mouseY, partialTicks);
            }
            for (GuiLabel aLabelList : this.field_146293_o) {
                aLabelList.func_146159_a(this.field_146297_k, mouseX, mouseY);
            }
        }
        catch (Exception ex) {
            Log.fatal("Fatal Error Drawing Screen:");
            Log.fatal(ex);
        }
    }

    public void createNewWorldClick() {
        DefaultWorldGenerator.selectedLevel = this.presetData;
    }
}

