/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.darkutils.features;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.darkhax.bookshelf.lib.Constants;
import net.darkhax.bookshelf.util.AnnotationUtils;
import net.darkhax.darkutils.features.DUFeature;
import net.darkhax.darkutils.features.Feature;
import net.darkhax.darkutils.handler.ConfigurationHandler;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.discovery.ASMDataTable;

public class FeatureManager {
    private static final List<Feature> features = new ArrayList<Feature>();
    private static boolean loaded = false;

    public static void init(ASMDataTable asmDataTable) {
        loaded = true;
        for (Map.Entry feature : AnnotationUtils.getAnnotations((ASMDataTable)asmDataTable, DUFeature.class, Feature.class).entrySet()) {
            DUFeature annotation = (DUFeature)feature.getValue();
            if (annotation == null) {
                Constants.LOG.warn("Annotation for " + ((Feature)feature.getKey()).getClass().getCanonicalName() + " was null!", new Object[0]);
                continue;
            }
            FeatureManager.registerFeature((Feature)feature.getKey(), annotation.name(), annotation.description());
        }
        features.sort((o1, o2) -> o2.configName.compareTo(o1.configName));
    }

    public static void registerFeature(Feature feature, String name, String description) {
        feature.enabled = ConfigurationHandler.isFeatureEnabled(feature, name, description);
        if (feature.enabled) {
            feature.configName = name.toLowerCase().replace(' ', '_');
            features.add(feature);
            if (feature.usesEvents()) {
                MinecraftForge.EVENT_BUS.register((Object)feature);
            }
        }
    }

    public static boolean isLoaded() {
        return loaded;
    }

    public static List<Feature> getFeatures() {
        return features;
    }
}

