/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.api.logger;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.api.player.IPlayer;
import crafttweaker.runtime.ILogger;
import java.util.ArrayList;
import java.util.List;

public class MTLogger
implements ILogger {
    private final List<ILogger> loggers = new ArrayList<ILogger>();
    private final List<IPlayer> players = new ArrayList<IPlayer>();
    private final List<ErrorMessage> unprocessed = new ArrayList<ErrorMessage>();
    private boolean isDefaultDisabled = false;

    public void addLogger(ILogger logger) {
        this.loggers.add(logger);
    }

    public void removeLogger(ILogger logger) {
        this.loggers.remove(logger);
    }

    public void addPlayer(IPlayer player) {
        this.players.add(player);
        this.logPlayer(player);
    }

    public void removePlayer(IPlayer player) {
        this.players.remove(player);
    }

    public void clear() {
        this.unprocessed.clear();
    }

    @Override
    public void logCommand(String message) {
        for (ILogger logger : this.loggers) {
            logger.logCommand(message);
        }
    }

    @Override
    public void logInfo(String message) {
        for (ILogger logger : this.loggers) {
            logger.logInfo(message);
        }
    }

    @Override
    public void logWarning(String message) {
        for (ILogger logger : this.loggers) {
            logger.logWarning(message);
        }
        String message2 = "\u00a7eWARNING: " + message;
        if (this.players.isEmpty()) {
            this.unprocessed.add(new ErrorMessage(message2, true));
        } else if (!CraftTweakerAPI.isSuppressingWarnings()) {
            this.players.forEach(player -> player.sendChat(message2));
        }
    }

    @Override
    public void logError(String message) {
        this.logError(message, null);
    }

    @Override
    public void logError(String message, Throwable exception) {
        for (ILogger logger : this.loggers) {
            logger.logError(message, exception);
        }
        String message2 = "\u00a7cERROR: " + this.getMessageToSendPlayer(message, exception);
        if (this.players.isEmpty()) {
            this.unprocessed.add(new ErrorMessage(message2, false));
        } else if (!CraftTweakerAPI.isSuppressingErrors()) {
            this.players.forEach(player -> player.sendChat(message2));
        }
    }

    @Override
    public void logPlayer(IPlayer player) {
        for (ErrorMessage errorMessage : this.unprocessed) {
            if (errorMessage.isWarning && !CraftTweakerAPI.isSuppressingWarnings()) {
                player.sendChat(errorMessage.message);
                continue;
            }
            if (errorMessage.isWarning || CraftTweakerAPI.isSuppressingErrors()) continue;
            player.sendChat(errorMessage.message);
        }
    }

    @Override
    public void logDefault(String message) {
        if (!this.isLogDisabled()) {
            this.logInfo(message);
        }
    }

    @Override
    public boolean isLogDisabled() {
        return this.isDefaultDisabled;
    }

    @Override
    public void setLogDisabled(boolean logDisabled) {
        this.isDefaultDisabled = logDisabled;
    }

    public String getMessageToSendPlayer(String message, Throwable exception) {
        if (exception == null) {
            return message;
        }
        if (message == null) {
            return String.valueOf(exception);
        }
        return message + ", caused by " + exception;
    }

    private static class ErrorMessage {
        final String message;
        final boolean isWarning;

        public ErrorMessage(String message, boolean isWarning) {
            this.message = message;
            this.isWarning = isWarning;
        }
    }
}

