/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.block;

import java.util.List;
import javax.annotation.Nullable;
import net.blay09.mods.cookingforblockheads.block.BlockKitchen;
import net.blay09.mods.cookingforblockheads.tile.TileToolRack;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockToolRack
extends BlockKitchen {
    public static final String name = "tool_rack";
    public static final ResourceLocation registryName = new ResourceLocation("cookingforblockheads", "tool_rack");
    private static final AxisAlignedBB[] BOUNDING_BOXES = new AxisAlignedBB[]{new AxisAlignedBB(0.0, 0.25, 0.875, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, 0.25, 0.0, 1.0, 1.0, 0.125), new AxisAlignedBB(0.875, 0.25, 0.0, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, 0.25, 0.0, 0.125, 1.0, 1.0)};

    public BlockToolRack() {
        super(Material.field_151575_d);
        this.func_149663_c(registryName.toString());
        this.func_149672_a(SoundType.field_185848_a);
        this.func_149711_c(2.5f);
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return new TileToolRack();
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        return BOUNDING_BOXES[facing.func_176745_a() - 2];
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess world, BlockPos pos) {
        return field_185506_k;
    }

    @Override
    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        if (facing == EnumFacing.UP || facing == EnumFacing.DOWN) {
            facing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (hand != EnumHand.MAIN_HAND) {
            return true;
        }
        ItemStack heldItem = player.func_184586_b(hand);
        if (!heldItem.func_190926_b() && heldItem.func_77973_b() instanceof ItemBlock) {
            return true;
        }
        if (hitY > 0.25f) {
            EnumFacing stateFacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
            float hit = hitX;
            switch (stateFacing) {
                case NORTH: {
                    hit = hitX;
                    break;
                }
                case SOUTH: {
                    hit = 1.0f - hitX;
                    break;
                }
                case WEST: {
                    hit = 1.0f - hitZ;
                    break;
                }
                case EAST: {
                    hit = hitZ;
                }
            }
            int hitSlot = hit > 0.5f ? 0 : 1;
            TileToolRack tileToolRack = (TileToolRack)world.func_175625_s(pos);
            if (tileToolRack != null) {
                if (!heldItem.func_190926_b()) {
                    ItemStack oldToolItem = tileToolRack.getItemHandler().getStackInSlot(hitSlot);
                    ItemStack toolItem = heldItem.func_77979_a(1);
                    if (!oldToolItem.func_190926_b()) {
                        if (!player.field_71071_by.func_70441_a(oldToolItem)) {
                            player.func_71019_a(oldToolItem, false);
                        }
                        tileToolRack.getItemHandler().setStackInSlot(hitSlot, toolItem);
                    } else {
                        tileToolRack.getItemHandler().setStackInSlot(hitSlot, toolItem);
                    }
                } else {
                    ItemStack itemStack = tileToolRack.getItemHandler().getStackInSlot(hitSlot);
                    if (!itemStack.func_190926_b()) {
                        tileToolRack.getItemHandler().setStackInSlot(hitSlot, ItemStack.field_190927_a);
                        player.func_184611_a(hand, itemStack);
                    }
                }
                return true;
            }
        }
        return true;
    }

    @Override
    public void func_190948_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag advanced) {
        super.func_190948_a(stack, world, tooltip, advanced);
        for (String s : I18n.func_135052_a((String)("tooltip." + registryName + ".description"), (Object[])new Object[0]).split("\\\\n")) {
            tooltip.add(TextFormatting.GRAY + s);
        }
    }
}

