/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.tracking.types;

import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistry;
import pregenerator.impl.tracking.WorldTracker;
import pregenerator.impl.tracking.types.BaseWorldEntry;
import pregenerator.impl.tracking.types.IWorldEntry;

public class BiomeEntry
extends BaseWorldEntry {
    public BiomeEntry(PacketBuffer buf) {
        super(buf);
    }

    public BiomeEntry(int id, int count) {
        super(id, count);
    }

    @Override
    protected ResourceLocation getKey(int id) {
        return ((Biome)((ForgeRegistry)ForgeRegistries.BIOMES).getValue(id)).getRegistryName();
    }

    public static List<IWorldEntry> getChunk(Chunk chunk) {
        BaseWorldEntry.Counter<Object> counter = new BaseWorldEntry.Counter<Object>();
        for (byte biome : chunk.func_76605_m()) {
            counter.add(((ForgeRegistry)ForgeRegistries.BIOMES).getValue(biome & 0xFF));
        }
        return counter.map((T, C) -> new BiomeEntry(BiomeEntry.getId(ForgeRegistries.BIOMES, T), C));
    }

    @Override
    public boolean canDelete(boolean chunk) {
        return false;
    }

    @Override
    public int deleteWorld(WorldTracker tacker, EntityPlayer player) {
        return 0;
    }

    @Override
    public int deleteChunk(WorldTracker tracker, long position) {
        return 0;
    }
}

