/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.tracking;

import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import pregenerator.ChunkPregenerator;
import pregenerator.PregenConfig;
import pregenerator.impl.tracking.AverageCounter;
import pregenerator.impl.tracking.TimeTracker;
import pregenerator.impl.tracking.WorldTracker;

public class ServerTracker {
    public static final ServerTracker INSTANCE = new ServerTracker();
    Map<World, WorldTracker> mapping = Collections.synchronizedMap(new LinkedHashMap());
    TimeTracker tracker = new TimeTracker(40);
    AverageCounter packets = new AverageCounter(40);

    public void init() {
        ChunkPregenerator.BASE_API.registerTickEvent(this);
        PregenConfig.INSTANCE.getHandler().addLoadedListener(this::updateState);
    }

    public void setState(boolean value) {
        PregenConfig config = PregenConfig.INSTANCE;
        config.tracker.set((Object)value);
        config.save();
    }

    private void updateState() {
        for (WorldTracker entry : this.mapping.values()) {
            entry.setState(this.isEnabled());
        }
    }

    public void enable() {
        this.setState(true);
    }

    public void disable() {
        this.setState(false);
    }

    public boolean isEnabled() {
        return PregenConfig.INSTANCE.tracker.get();
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        if (event.phase == TickEvent.Phase.START) {
            this.tracker.setStart();
            this.packets.addMore(this.getServer().field_175589_i.size());
            this.packets.onFinished();
        } else {
            this.tracker.onFinished();
        }
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        WorldTracker tracker = this.mapping.get(event.world);
        if (tracker != null) {
            if (event.phase == TickEvent.Phase.START) {
                tracker.onTickStart();
            } else {
                tracker.onTickEnd();
            }
        }
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load load) {
        World world = load.getWorld();
        if (world instanceof WorldServer) {
            this.mapping.put(world, new WorldTracker((WorldServer)world, this.isEnabled()));
        }
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload unload) {
        this.mapping.remove(unload.getWorld());
    }

    public void onServerStopped() {
        this.mapping.clear();
    }

    public MinecraftServer getServer() {
        return FMLCommonHandler.instance().getMinecraftServerInstance();
    }

    public WorldTracker getWorld(int dim) {
        return this.mapping.get(DimensionManager.getWorld((int)dim));
    }

    public WorldTracker getWorld(World world) {
        return this.mapping.get(world);
    }

    public long getAverage() {
        return this.tracker.getAverage();
    }

    public int getPackets() {
        return this.packets.getAverage();
    }

    public List<WorldTracker> getTracker() {
        return new ArrayList<WorldTracker>(this.mapping.values());
    }

    public byte[] getProfilerData(int dimension, EntityPlayer player) {
        if (!this.isEnabled()) {
            return new byte[0];
        }
        PacketBuffer buf = new PacketBuffer(Unpooled.buffer());
        buf.func_179254_b(this.tracker.getAverage());
        Runtime runtime = Runtime.getRuntime();
        buf.writeLong(runtime.totalMemory());
        buf.writeLong(runtime.maxMemory());
        buf.writeLong(runtime.freeMemory());
        buf.func_150787_b(this.packets.getAverage());
        buf.func_150787_b(this.packets.getLast());
        buf.func_150787_b(this.mapping.size());
        this.mapping.forEach((K, V) -> {
            buf.writeInt(K.field_73011_w.getDimension());
            buf.func_179254_b(V.getAverage());
        });
        WorldTracker tracker = this.getWorld(dimension);
        buf.writeBoolean(tracker != null);
        if (tracker != null) {
            tracker.writeTrackingData(buf);
        }
        byte[] data = new byte[buf.writerIndex()];
        buf.readBytes(data);
        return data;
    }
}

