/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.tracking;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CollectorMap<T> {
    Map<Class<T>, Set<T>> dataMap = new HashMap<Class<T>, Set<T>>();
    List<T> allEntries = new LinkedList<T>();

    public void addEntry(T data) {
        this.allEntries.add(data);
        Set<T> set = this.dataMap.get(data.getClass());
        if (set == null) {
            set = new HashSet<T>();
            this.dataMap.put(data.getClass(), set);
        }
        set.add(data);
    }

    public void addAll(Collection<T> data) {
        for (T entry : data) {
            this.addEntry(entry);
        }
    }

    public Set<Map.Entry<Class<T>, Set<T>>> entrySet() {
        return this.dataMap.entrySet();
    }

    public void removeAll(Class<? extends T> type) {
        Iterator<Map.Entry<Class<T>, Set<T>>> iter = this.dataMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Class<T>, Set<T>> entry = iter.next();
            if (!type.isAssignableFrom(entry.getKey())) continue;
            this.allEntries.removeAll((Collection)entry.getValue());
            iter.remove();
        }
    }

    public List<T> getAllOfType(Class<?> clz) {
        Set<T> set = this.dataMap.get(clz);
        if (set != null) {
            return new ArrayList<T>(set);
        }
        return new ArrayList();
    }

    public int size() {
        return this.allEntries.size();
    }

    public boolean isEmpty() {
        return this.allEntries.isEmpty();
    }

    public int getTypeCount() {
        return this.dataMap.size();
    }
}

