/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.processor.minitasks;

import it.unimi.dsi.fastutil.objects.ObjectLists;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.FMLCommonHandler;
import pregenerator.impl.processor.minitasks.IMiniTask;
import pregenerator.impl.storage.GlobalListeners;
import pregenerator.impl.storage.ProcessListener;

public abstract class BaseScanTask
implements IMiniTask {
    protected int dimension;
    protected UUID source;

    public BaseScanTask(int dimension, UUID source) {
        this.dimension = dimension;
        this.source = source;
    }

    protected void sendMessage(ITextComponent component) {
        GlobalListeners.INSTANCE.sendMessage(component);
    }

    protected void sendForceMessage(ITextComponent component) {
        this.sendMessage(component);
        if (!GlobalListeners.INSTANCE.containsListener(ProcessListener.create(this.source))) {
            ProcessListener.create(this.source).sendMessage(component);
        }
    }

    protected boolean isRegionFile(Path path) {
        return path.getFileName().toString().endsWith(".mca");
    }

    protected List<Path> getRegionFiles() {
        try {
            MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
            String folder = DimensionManager.createProviderFor((int)this.dimension).getSaveFolder();
            Path path = server.func_71254_M().func_186352_b(server.func_71270_I(), ".").toPath().resolve(folder == null ? "." : folder);
            ArrayList<Path> result = new ArrayList<Path>();
            Files.newDirectoryStream(path.resolve("region"), this::isRegionFile).iterator().forEachRemaining(result::add);
            return result;
        }
        catch (IOException e) {
            return ObjectLists.emptyList();
        }
    }

    protected Path getSaveFile() {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        return server.func_71254_M().func_186352_b(server.func_71270_I(), ".").toPath();
    }

    protected ChunkPos getRegionPosition(Path regionFile) {
        try {
            String[] name = regionFile.getFileName().toString().split("\\.");
            return new ChunkPos(Integer.parseInt(name[1]), Integer.parseInt(name[2]));
        }
        catch (Exception e) {
            return null;
        }
    }
}

