/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.processor.generator.tasks;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.WorldServer;
import pregenerator.base.api.TextUtil;
import pregenerator.impl.misc.FilePos;
import pregenerator.impl.processor.ChunkCalculator;
import pregenerator.impl.processor.PrepareProgress;
import pregenerator.impl.processor.generator.ChunkProcess;
import pregenerator.impl.processor.generator.GenerationType;
import pregenerator.impl.processor.generator.tasks.BaseTask;
import pregenerator.impl.processor.generator.tasks.ITask;

public class SquareExpansionTask
extends BaseTask {
    long center;
    int minRadius;
    int maxRadius;

    public SquareExpansionTask(String name, int dimensionId, GenerationType genType, FilePos center, int minRadius, int maxRadius) {
        super(name, dimensionId, genType);
        this.center = center.asLong();
        this.minRadius = minRadius;
        this.maxRadius = maxRadius;
    }

    public SquareExpansionTask(NBTTagCompound nbt) {
        super(nbt);
        this.center = nbt.func_74763_f("center");
        this.minRadius = nbt.func_74762_e("min_radius");
        this.maxRadius = nbt.func_74762_e("max_radius");
    }

    @Override
    public NBTTagCompound write() {
        NBTTagCompound nbt = super.write();
        nbt.func_74772_a("center", this.center);
        nbt.func_74768_a("min_radius", this.minRadius);
        nbt.func_74768_a("max_radius", this.maxRadius);
        return nbt;
    }

    @Override
    public byte getId() {
        return 3;
    }

    @Override
    public ITextComponent getShapeName() {
        return TextUtil.translate("task.chunk_pregen.shape_type.square_expansion");
    }

    @Override
    public ChunkPos getCenter() {
        return new ChunkPos(FilePos.getX(this.center), FilePos.getZ(this.center));
    }

    @Override
    public int getMaxRadius() {
        return this.maxRadius;
    }

    @Override
    public long getTaskSize() {
        return (long)(this.maxRadius * this.maxRadius) * 4L - (long)(this.minRadius * this.minRadius) * 4L;
    }

    @Override
    protected void append(ITextComponent text) {
        ChunkPos center = new ChunkPos(FilePos.getX(this.center), FilePos.getZ(this.center));
        ITask.insert("task.chunk_pregen.task_type", TextUtil.translate("task.chunk_pregen.shape_type.square_expansion"), text, TextFormatting.DARK_PURPLE);
        ITask.insert("task.chunk_pregen.x_coord", center.field_77276_a, text, TextFormatting.YELLOW);
        ITask.insert("task.chunk_pregen.z_coord", center.field_77275_b, text, TextFormatting.YELLOW);
        ITask.insert("task.chunk_pregen.min_radius", this.minRadius, text, TextFormatting.BLUE);
        ITask.insert("task.chunk_pregen.max_radius", this.maxRadius, text, TextFormatting.BLUE);
    }

    @Override
    protected ChunkProcess createTask(WorldServer world, PrepareProgress progress) {
        long diameter = (long)this.maxRadius * 2L;
        progress.setMax(diameter * diameter);
        ChunkProcess process = new ChunkProcess(world, this);
        FilePos center = new FilePos(this.center);
        process.addTaskList(ChunkCalculator.getSquareExspansionShape(center.x, center.z, this.minRadius, this.maxRadius, progress), center, progress);
        return process;
    }
}

