/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.processor.generator;

import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import net.minecraft.network.PacketBuffer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.ThreadedFileIOBase;
import net.minecraftforge.fml.common.FMLCommonHandler;
import org.apache.commons.lang3.time.DurationFormatUtils;
import pregenerator.ChunkPregenerator;
import pregenerator.PregenConfig;
import pregenerator.base.api.TextUtil;
import pregenerator.impl.commands.BaseCommands;
import pregenerator.impl.misc.Area;
import pregenerator.impl.misc.ChunkTimer;
import pregenerator.impl.misc.DeltaTimer;
import pregenerator.impl.misc.FileCounter;
import pregenerator.impl.misc.ProcessResult;
import pregenerator.impl.processor.IBaseTask;
import pregenerator.impl.processor.IProcessor;
import pregenerator.impl.processor.PrepareProgress;
import pregenerator.impl.processor.ServerManager;
import pregenerator.impl.processor.generator.BenchmarkManager;
import pregenerator.impl.processor.generator.ChunkLogger;
import pregenerator.impl.processor.generator.ChunkProcess;
import pregenerator.impl.processor.generator.ChunkThread;
import pregenerator.impl.processor.generator.tasks.ITask;
import pregenerator.impl.storage.GlobalListeners;
import pregenerator.impl.storage.PregenTaskStorage;

public class ChunkProcessor
implements IProcessor {
    public static final ChunkProcessor INSTANCE = new ChunkProcessor();
    public static final int IDLE_MODE = 0;
    public static final int PROCESSING_MODE = 1;
    public static final int POST_PROCESSING_MODE = 2;
    int ticker = 0;
    DeltaTimer timer = new DeltaTimer();
    ChunkTimer chunkTimer = new ChunkTimer();
    FileCounter counter = new FileCounter();
    FileCounter memoryAverage = new FileCounter();
    public PrepareProgress progress = new PrepareProgress();
    Future<ChunkProcess> future = null;
    ITask task = null;
    ChunkProcess currentTask = null;
    long processed = 0L;
    long skipped = 0L;
    long failed = 0L;
    Instant startTime;
    boolean wasFull;
    boolean working = false;
    boolean paused = false;
    AtomicLong threadID = new AtomicLong(-1L);

    @Override
    public void onTickStart() {
        if (this.isStopped() || this.task == null || this.shouldDisable() || this.currentTask == null) {
            return;
        }
        this.timer.start();
    }

    @Override
    public void onTickEnd() {
        block28: {
            long maxTimePerTick;
            if (this.isStopped() || this.task == null || this.shouldDisable()) {
                return;
            }
            if (this.future != null) {
                int newTime = this.getTicker();
                if (this.ticker != newTime) {
                    this.ticker = newTime;
                    long value = this.progress.getCurrent();
                    long max = this.progress.getMax();
                    double progress = (double)value / (double)max * 100.0;
                    this.sendMessage(TextUtil.applyTextStyle(TextUtil.translate("process.chunk_pregen.prepare", TextUtil.NUMBERS.format(value), TextUtil.NUMBERS.format(max), TextUtil.FLOATING_NUMBERS.format(progress) + "%").func_150259_f(), TextFormatting.AQUA));
                }
                if (this.future.isDone()) {
                    try {
                        this.currentTask = this.future.get();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    this.future = null;
                    if (this.currentTask != null) {
                        this.currentTask.setStartMemory();
                    }
                    this.progress.reset();
                }
                return;
            }
            if (this.currentTask == null) {
                return;
            }
            long deltaTime = this.timer.averageDelta();
            if (deltaTime >= (maxTimePerTick = (long)PregenConfig.INSTANCE.timePerTick.get())) {
                this.working = false;
                return;
            }
            this.working = true;
            if (((BaseCommands.Priority)PregenConfig.INSTANCE.priority.get()).isPregenerator()) {
                deltaTime = 0L;
            }
            this.chunkTimer.startTime();
            this.currentTask.onTickStart();
            try {
                while (deltaTime + this.timer.getDeltaTime() < maxTimePerTick && this.currentTask.hasWork()) {
                    ProcessResult result = this.currentTask.tick();
                    if (this.currentTask.hasLight()) {
                        this.currentTask.checkLight();
                    }
                    ++this.processed;
                    this.counter.onChunkProcessed();
                    this.chunkTimer.onChunkFinished();
                    if (result == ProcessResult.CRASH) {
                        ++this.failed;
                        continue;
                    }
                    if (result != ProcessResult.MISSING) continue;
                    ++this.skipped;
                }
                int newTime = this.getTicker();
                if (newTime != this.ticker) {
                    this.ticker = newTime;
                    this.buildPreText();
                }
                if (!this.currentTask.hasWork()) {
                    if (this.currentTask.hasLight()) {
                        this.currentTask.checkLight();
                    } else {
                        this.onFinished();
                    }
                    break block28;
                }
                this.counter.onTickEnded();
                this.timer.finishDeltaTime();
                this.memoryAverage.add(this.freeMemory());
                PregenConfig config = PregenConfig.INSTANCE;
                if (config.memoryProtector.get() && config.memoryLimit.get() > this.memoryAverage.getIntAverage()) {
                    try {
                        for (WorldServer world : this.getServer().field_71305_c) {
                            if (world == null) continue;
                            boolean flag = world.field_73058_d;
                            world.field_73058_d = false;
                            world.func_73044_a(true, (IProgressUpdate)null);
                            world.field_73058_d = flag;
                        }
                        ThreadedFileIOBase.func_178779_a().func_75734_a();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    ChunkPregenerator.LOGGER.info("Auto Restart Enabled (Can be disabled at own Risk)");
                    ChunkPregenerator.LOGGER.info("Average Free RAM [" + this.memoryAverage.getAverage() + " MB] is below the suggested amount [" + PregenConfig.INSTANCE.memoryLimit.get() + " MB]");
                    ChunkPregenerator.LOGGER.info("Risk of world corruption because of low RAM");
                    ChunkPregenerator.LOGGER.info("Forcing Restart of the Game now to ensure enough RAM");
                    ChunkPregenerator.LOGGER.info("Pregenerator Progress is saved!");
                    ChunkPregenerator.LOGGER.info("All Worlds are saved");
                    ChunkPregenerator.LOGGER.info("Enforing Shutdown!");
                    FMLCommonHandler.instance().exitJava(0, true);
                    return;
                }
                if (this.task != null) {
                    if (this.wasFull != this.counter.isFull()) {
                        boolean wasntFull = !this.wasFull;
                        this.wasFull = this.counter.isFull();
                        if (wasntFull) {
                            PregenConfig.INSTANCE.storeSpeed(this.task.getDimension(), this.counter.getAverage());
                        }
                    } else if (this.wasFull && this.ticker % 24000 == 0) {
                        PregenConfig.INSTANCE.storeSpeed(this.task.getDimension(), this.counter.getAverage());
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
    }

    public void startTask(ITask task) {
        this.task = task;
        this.future = task.createTask(this.progress);
        this.startTime = Instant.now();
        this.wasFull = false;
        System.gc();
        this.threadID.incrementAndGet();
        PregenConfig.INSTANCE.setAutoResume(true);
        Thread thread = new Thread((Runnable)new ChunkThread(this), "Chunk Processor Thread");
        thread.setDaemon(true);
        thread.start();
        ServerManager.INSTANCE.setActiveTask(this);
    }

    @Override
    public void pauseTask() {
        if (this.currentTask == null || this.paused) {
            return;
        }
        this.paused = true;
        this.task.addActiveTime(Duration.between(this.startTime, Instant.now()).toMillis());
    }

    @Override
    public void resumeTask() {
        if (this.currentTask == null || !this.paused) {
            return;
        }
        this.paused = false;
        this.startTime = Instant.now();
        this.timer.reset();
    }

    @Override
    public void stop(boolean notify) {
        this.interruptTask(notify);
    }

    public void interruptTask(boolean notify) {
        this.interruptTask(notify, true);
    }

    public void interruptTask(boolean notify, boolean cleanup) {
        if (this.task == null) {
            return;
        }
        this.cleanup(cleanup);
        if (notify) {
            this.sendMessage(TextUtil.translate("process.chunk_pregen.interrupt"));
        }
        if (BenchmarkManager.INSTANCE.isBenchmarkRunning()) {
            BenchmarkManager.INSTANCE.interruptBenchmark();
        }
        ServerManager.INSTANCE.onTaskCompleted();
    }

    private void onFinished() {
        WorldServer world = this.currentTask.world;
        long processed = this.processed - this.skipped;
        Duration workTime = this.getWorkTime();
        ITask task = this.currentTask.getTask();
        this.sendMessage(TextUtil.translate("process.chunk_pregen.finish", this.getTime(), processed));
        PregenTaskStorage storage = PregenTaskStorage.getStorage();
        storage.onTaskFinished(task);
        task.onTaskStopped((World)world, workTime, processed);
        this.sendMessage(TextUtil.translate("process.chunk_pregen.finish.cleanup"));
        this.cleanup(true);
        IBaseTask next = storage.getNextTask();
        if (next != null) {
            this.sendMessage(TextUtil.translate("process.chunk_pregen.start_next", task.getName()));
            next.start();
        } else {
            if (BenchmarkManager.INSTANCE.isBenchmarkRunning()) {
                BenchmarkManager.INSTANCE.onBenchmarkFinished();
            }
            this.sendMessage(TextUtil.translate("process.chunk_pregen.finished"));
            ServerManager.INSTANCE.onTaskCompleted();
        }
    }

    private void cleanup(boolean cleanup) {
        if (this.currentTask != null) {
            this.currentTask.onRemove();
        }
        if (this.future != null) {
            this.future.cancel(false);
            this.future = null;
        }
        this.currentTask = null;
        this.failed = 0L;
        this.processed = 0L;
        this.skipped = 0L;
        this.startTime = null;
        this.chunkTimer.cleanUp();
        this.counter.reset();
        this.timer.reset();
        this.task = null;
        if (cleanup) {
            try {
                for (WorldServer world : this.getServer().field_71305_c) {
                    if (world == null) continue;
                    boolean flag = world.field_73058_d;
                    world.field_73058_d = false;
                    world.func_73044_a(true, (IProgressUpdate)null);
                    world.field_73058_d = flag;
                }
                ThreadedFileIOBase.func_178779_a().func_75734_a();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            PregenConfig.INSTANCE.setAutoResume(false);
        }
        System.gc();
    }

    public void buildPreText() {
        List log = PregenConfig.INSTANCE.loggerOrder.get();
        if (log.isEmpty()) {
            return;
        }
        ITextComponent text = TextUtil.translate("process.chunk_pregen.logger_split").func_150259_f();
        int m = log.size();
        for (int i = 0; i < m; ++i) {
            ChunkLogger entry = (ChunkLogger)((Object)log.get(i));
            entry.append(text, this);
            if (i == m - 1) continue;
            text.func_150257_a(TextUtil.translate("process.chunk_pregen.logger_split"));
        }
        this.sendMessage(text);
    }

    public void sendMessage(ITextComponent text) {
        GlobalListeners.INSTANCE.sendMessage(text);
    }

    public boolean isWorking() {
        return this.working;
    }

    @Override
    public ITask getTask() {
        return this.currentTask != null ? this.currentTask.getTask() : null;
    }

    @Override
    public boolean isPaused() {
        return this.paused;
    }

    public ChunkProcess getCurrentTask() {
        return this.currentTask;
    }

    public boolean shouldDisable() {
        if (this.paused) {
            return true;
        }
        int limit = PregenConfig.INSTANCE.playerLimit.get();
        return limit >= 0 && this.getServer().func_71233_x() >= limit;
    }

    public FileCounter getCounter() {
        return this.counter;
    }

    public boolean isStopped() {
        return this.task == null;
    }

    public boolean isRunning() {
        return this.task != null;
    }

    public boolean isProcessing() {
        return this.currentTask != null;
    }

    public int getLoadedChunks() {
        return this.currentTask != null ? this.currentTask.getProvider().func_73152_e() : 0;
    }

    public MinecraftServer getServer() {
        return FMLCommonHandler.instance().getMinecraftServerInstance();
    }

    long getRamUsage() {
        Runtime run = Runtime.getRuntime();
        return run.totalMemory() - run.freeMemory() >> 20;
    }

    int freeMemory() {
        Runtime run = Runtime.getRuntime();
        return (int)(run.maxMemory() - run.totalMemory() + run.freeMemory() >> 20);
    }

    private int getTicker() {
        return (int)(Duration.between(this.startTime, Instant.now()).toMillis() / 1000L);
    }

    public String getTime() {
        return DurationFormatUtils.formatDuration((long)this.getWorkTime().toMillis(), (String)"HH:mm:ss");
    }

    protected Duration getWorkTime() {
        Duration duration = Duration.between(Instant.now(), this.startTime).abs();
        return this.task == null ? duration : duration.plusMillis(this.task.getActiveTime());
    }

    public long getCurrentProcessed() {
        return this.processed;
    }

    public long getMaxProcess() {
        return this.currentTask != null ? this.currentTask.getTotalWorkList() : 0L;
    }

    public int getAverageCPUTime() {
        return this.timer.hasValues() ? (int)this.timer.getAverageDelta() : 0;
    }

    public int averageLagPerChunk() {
        return this.chunkTimer.hasValues() ? (int)this.chunkTimer.getAverage() : 0;
    }

    @Override
    public String getTaskName() {
        return this.task == null ? "" : this.task.getName();
    }

    @Override
    public long getExpectedTime() {
        if (this.currentTask == null) {
            return 0L;
        }
        float value = this.counter.getAverage();
        if (value <= 0.0f) {
            return 0L;
        }
        return (long)((float)(this.currentTask.getTotalWorkList() - this.processed) / value) * 50L;
    }

    @Override
    public byte getClientDataId() {
        return 1;
    }

    @Override
    public void sendClientData(PacketBuffer buffer) {
        buffer.writeBoolean(this.future != null || this.task == null || this.currentTask == null);
        buffer.func_180714_a(this.getTaskName());
        buffer.writeByte(this.task != null ? this.task.getType().ordinal() : -1);
        Runtime runtime = Runtime.getRuntime();
        buffer.writeLong(runtime.totalMemory());
        buffer.writeLong(runtime.maxMemory());
        buffer.writeLong(runtime.freeMemory());
        buffer.writeLong(this.timer.getAverageDelta());
        if (this.future != null || this.task == null || this.currentTask == null) {
            buffer.writeLong(this.progress == null ? 0L : this.progress.getCurrent());
            buffer.writeLong(this.progress == null ? 0L : this.progress.getMax());
            return;
        }
        buffer.writeBoolean(!this.paused);
        PregenConfig config = PregenConfig.INSTANCE;
        buffer.writeInt(config.timePerTick.get());
        buffer.writeBoolean(config.priority.get() == BaseCommands.Priority.PREGENERATOR);
        buffer.writeLong(this.getWorkTime().toMillis());
        buffer.writeLong(this.currentTask.getTotalWorkList());
        buffer.writeLong(this.processed);
        buffer.writeFloat(this.counter.getAverage());
        Area area = this.currentTask.getWorkingArea();
        buffer.writeBoolean(area != null);
        if (area != null) {
            area.write(buffer);
        }
        buffer.func_179252_a(this.task.getTaskId());
    }
}

