/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.processor.generator;

import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import org.apache.commons.lang3.time.DurationFormatUtils;
import pregenerator.PregenConfig;
import pregenerator.base.api.TextUtil;
import pregenerator.impl.misc.Area;
import pregenerator.impl.processor.generator.ChunkProcessor;
import pregenerator.impl.tracking.ServerTracker;
import pregenerator.impl.tracking.WorldTracker;

public enum ChunkLogger {
    Task{

        @Override
        public void append(ITextComponent text, ChunkProcessor processor) {
            ITextComponent name = TextUtil.applyTextStyle(TextUtil.translate("process.chunk_pregen.name", processor.getTaskName()), TextFormatting.RED);
            ITextComponent shape = TextUtil.applyTextStyle(TextUtil.translate("process.chunk_pregen.shape", processor.getTask().getShapeName()), TextFormatting.GOLD);
            text.func_150257_a(1.wrap(name)).func_150257_a(1.wrap(shape));
        }
    }
    ,
    World{

        @Override
        public void append(ITextComponent text, ChunkProcessor processor) {
            text.func_150257_a(2.wrap(TextUtil.applyTextStyle(TextUtil.translate("task.chunk_pregen.dimension", TextUtil.dimension(processor.getTask().getDimension())), TextFormatting.GREEN))).func_150258_a(" ");
            text.func_150257_a(2.wrap(TextUtil.applyTextStyle(TextUtil.translate("process.chunk_pregen.task_type", processor.task.getType().createText()), TextFormatting.DARK_AQUA)));
        }
    }
    ,
    TaskInfo{

        @Override
        public void append(ITextComponent text, ChunkProcessor processor) {
            String current = TextUtil.NUMBERS.format(processor.getCurrentProcessed());
            String total = TextUtil.NUMBERS.format(processor.getMaxProcess());
            text.func_150257_a(3.wrap(TextUtil.applyTextStyle(TextUtil.translate("process.chunk_pregen.task", current, total), TextFormatting.BLUE)));
        }
    }
    ,
    ProcessingSpeed{

        @Override
        public void append(ITextComponent text, ChunkProcessor processor) {
            String task = TextUtil.FLOATING_NUMBERS.format(processor.getCounter().getAverage());
            text.func_150257_a(4.wrap(TextUtil.applyTextStyle(TextUtil.translate("process.chunk_pregen.speed", task), TextFormatting.AQUA)));
        }
    }
    ,
    LoadedFiles{

        @Override
        public void append(ITextComponent text, ChunkProcessor processor) {
            text.func_150257_a(5.wrap(TextUtil.applyTextStyle(TextUtil.translate("process.chunk_pregen.world_loaded_data", processor.getLoadedChunks(), processor.currentTask.getActiveRegionFiles()), TextFormatting.GOLD)));
        }
    }
    ,
    workingArea{

        @Override
        public void append(ITextComponent text, ChunkProcessor processor) {
            Area area = processor.currentTask.getWorkingArea();
            if (area != null) {
                text.func_150257_a(6.wrap(TextUtil.applyTextStyle(TextUtil.translate("process.chunk_pregen.working_area", area.getMinX(), area.getMinZ(), area.getMaxX(), area.getMaxZ()), TextFormatting.RED)));
            } else {
                text.func_150257_a(6.wrap(TextUtil.applyTextStyle(TextUtil.translate("process.chunk_pregen.working_area.fetching").func_150259_f(), TextFormatting.RED)));
            }
        }
    }
    ,
    ExpectedTime{

        @Override
        public void append(ITextComponent text, ChunkProcessor processor) {
            long total = processor.getMaxProcess();
            String main = this.getTime((long)((float)(total - processor.getCurrentProcessed()) / processor.getCounter().getAverage()) * Math.max(50L, (long)PregenConfig.INSTANCE.timePerTick.get()));
            text.func_150257_a(7.wrap(TextUtil.applyTextStyle(TextUtil.translate("process.chunk_pregen.time", main, processor.getTime()), TextFormatting.GREEN)));
        }
    }
    ,
    RamUsage{

        @Override
        public void append(ITextComponent text, ChunkProcessor processor) {
            WorldTracker tracker = ServerTracker.INSTANCE.getWorld(processor.task.getDimension());
            text.func_150257_a(8.wrap(TextUtil.applyTextStyle(TextUtil.ram(), TextFormatting.LIGHT_PURPLE)));
            text.func_150257_a(8.wrap(TextUtil.applyTextStyle(TextUtil.translate("process.chunk_pregen.ticks", tracker == null ? 0 : tracker.tickUpdates.size()), TextFormatting.BLUE)));
        }
    }
    ,
    Controls{

        @Override
        public void append(ITextComponent text, ChunkProcessor processor) {
            String pause = "/pregen pause";
            String resume = "/pregen resume";
            String unlisten = "/pregen info unlisten";
            String listen = "/pregen info listen";
            String stop = "/pregen stop " + processor.getTaskName();
            String cont = "/pregen continue " + processor.getTaskName();
            String delete = "/pregen clear " + processor.getTaskName();
            text.func_150257_a(9.wrap(TextUtil.translate("process.chunk_pregen.actions.listen").func_150259_f().func_150255_a(new Style().func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, listen)).func_150238_a(TextFormatting.GREEN))));
            text.func_150257_a(9.wrap(TextUtil.translate("process.chunk_pregen.actions.mute").func_150259_f().func_150255_a(new Style().func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, unlisten)).func_150238_a(TextFormatting.RED))));
            text.func_150257_a(9.wrap(TextUtil.translate("process.chunk_pregen.actions.pause").func_150259_f().func_150255_a(new Style().func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, pause)).func_150238_a(TextFormatting.AQUA))));
            text.func_150257_a(9.wrap(TextUtil.translate("process.chunk_pregen.actions.resume").func_150259_f().func_150255_a(new Style().func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, resume)).func_150238_a(TextFormatting.BLUE))));
            text.func_150257_a(9.wrap(TextUtil.translate("process.chunk_pregen.actions.stop").func_150259_f().func_150255_a(new Style().func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, stop)).func_150238_a(TextFormatting.YELLOW))));
            text.func_150257_a(9.wrap(TextUtil.translate("process.chunk_pregen.actions.continue").func_150259_f().func_150255_a(new Style().func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, cont)).func_150238_a(TextFormatting.DARK_AQUA))));
            text.func_150257_a(9.wrap(TextUtil.translate("process.chunk_pregen.actions.remove").func_150259_f().func_150255_a(new Style().func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, delete)).func_150238_a(TextFormatting.GOLD))));
        }
    };


    public static ITextComponent wrap(ITextComponent text) {
        return TextUtil.translate("process.chunk_pregen.wrap", text);
    }

    protected String getTime(long time) {
        return DurationFormatUtils.formatDuration((long)Math.abs(time), (String)"HH:mm:ss");
    }

    public void append(ITextComponent text, ChunkProcessor processor) {
    }
}

