/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.processor.generator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ReportedException;
import net.minecraft.world.MinecraftException;
import net.minecraft.world.NextTickListEntry;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.AnvilChunkLoader;
import net.minecraft.world.chunk.storage.IChunkLoader;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import pregenerator.ChunkPregenerator;
import pregenerator.impl.misc.FilePos;
import pregenerator.impl.tracking.ServerTracker;
import pregenerator.impl.tracking.WorldTracker;

public class ChunkHelper {
    ChunkProviderServer server;
    WorldServer world;
    Set<NextTickListEntry> set;
    List<Entity> entities;

    public ChunkHelper(ChunkProviderServer data, WorldServer worlding) {
        this.server = data;
        this.world = worlding;
        WorldTracker tracker = ServerTracker.INSTANCE.getWorld((World)worlding);
        this.set = tracker != null ? tracker.tickUpdates : new HashSet<NextTickListEntry>();
        try {
            this.entities = (List)ReflectionHelper.getPrivateValue(World.class, (Object)this.world, (String[])new String[]{"unloadedEntityList", "field_72997_g"});
        }
        catch (Exception e) {
            this.entities = new ArrayList<Entity>();
            e.printStackTrace();
        }
    }

    public boolean containsChunk(long pos) {
        return this.server.field_73244_f.containsKey(pos);
    }

    public void storeChunk(long pos, Chunk chunk) {
        this.server.field_73244_f.put(pos, (Object)chunk);
    }

    public int getChunkCount() {
        return this.server.field_73244_f.size();
    }

    public void clearUnloadedEntities() {
        this.entities.clear();
    }

    public void unloadChunk(Chunk chunk) {
        this.server.func_189549_a(chunk);
    }

    public void cleanUp() {
    }

    public Chunk createChunk(int x, int z, boolean disablePost, boolean post) {
        try {
            Chunk chunk = this.server.field_186029_c.func_185932_a(x, z);
            if (disablePost) {
                chunk.func_177446_d(true);
            }
            if (post) {
                this.storeChunk(FilePos.asLong(x, z), chunk);
            } else {
                this.saveChunk(chunk);
            }
            return chunk;
        }
        catch (Throwable throwable) {
            long i = FilePos.asLong(x, z);
            CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Exception generating new chunk");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Chunk to be generated");
            crashreportcategory.func_71507_a("Location", (Object)String.format("%d,%d", x, z));
            crashreportcategory.func_71507_a("Position hash", (Object)i);
            crashreportcategory.func_71507_a("Generator", (Object)this.server.field_186029_c);
            throw new ReportedException(crashreport);
        }
    }

    public Chunk loadChunk(int x, int z) {
        Chunk chunk = this.server.func_186026_b(x, z);
        if (chunk == null) {
            IChunkLoader loader = this.server.field_73247_e;
            if (loader instanceof AnvilChunkLoader) {
                AnvilChunkLoader anvil = (AnvilChunkLoader)loader;
                try {
                    Object[] data = anvil.loadChunk__Async((World)this.world, x, z);
                    if (data == null) {
                        ChunkPregenerator.LOGGER.info("Tried to Load a Chunk that doesn't exists! at [x=" + x + ", y=" + z + "] Please make sure that that one is deleted!");
                        return null;
                    }
                    chunk = (Chunk)data[0];
                    NBTTagCompound nbt = (NBTTagCompound)data[1];
                    anvil.loadEntities((World)this.world, nbt.func_74775_l("Level"), chunk);
                    MinecraftForge.EVENT_BUS.post((Event)new ChunkDataEvent.Load(chunk, nbt));
                    chunk.func_177432_b(this.world.func_82737_E());
                    this.server.field_186029_c.func_180514_a(chunk, x, z);
                    this.storeChunk(FilePos.asLong(x, z), chunk);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                try {
                    chunk = loader.func_75815_a((World)this.world, x, z);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return chunk;
    }

    public void saveChunk(Chunk chunk) {
        try {
            chunk.func_177432_b(this.world.func_82737_E());
            this.server.field_73247_e.func_75816_a((World)this.world, chunk);
            chunk.func_177427_f(false);
        }
        catch (IOException ioexception) {
            ChunkPregenerator.LOGGER.error("Couldn't save chunk", (Throwable)ioexception);
        }
        catch (MinecraftException minecraftexception) {
            ChunkPregenerator.LOGGER.error("Couldn't save chunk; already in use by another instance of Minecraft?", (Throwable)minecraftexception);
        }
    }
}

