/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.processor.deleter.tasks;

import it.unimi.dsi.fastutil.objects.ObjectIterators;
import it.unimi.dsi.fastutil.objects.ObjectLists;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Future;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.FMLCommonHandler;
import pregenerator.ChunkPregenerator;
import pregenerator.base.api.TextUtil;
import pregenerator.impl.misc.Area;
import pregenerator.impl.processor.PrepareProgress;
import pregenerator.impl.processor.deleter.DeleteProcess;
import pregenerator.impl.processor.deleter.DeleteProcessor;
import pregenerator.impl.processor.deleter.tasks.IDeletionTask;
import pregenerator.impl.processor.generator.tasks.ITask;

public abstract class BaseDeletionTask
implements IDeletionTask {
    String name;
    int dimensionId;
    UUID task = UUID.randomUUID();
    long activeTime = 0L;

    public BaseDeletionTask(NBTTagCompound nbt) {
        this(nbt.func_74779_i("name"), nbt.func_74762_e("dim"));
        if (nbt.func_186855_b("taskId")) {
            this.task = nbt.func_186857_a("taskId");
        }
        this.activeTime = nbt.func_74763_f("active_time");
    }

    public BaseDeletionTask(String name, int dimensionId) {
        this.name = name;
        this.dimensionId = dimensionId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public UUID getTaskId() {
        return this.task;
    }

    @Override
    public int getDimension() {
        return this.dimensionId;
    }

    @Override
    public Area getArea() {
        return new Area(this.getCenter(), this.getMaxRadius());
    }

    @Override
    public long getActiveTime() {
        return this.activeTime;
    }

    @Override
    public void addActiveTime(long value) {
        this.activeTime += value;
    }

    @Override
    public ITextComponent getDescription() {
        ITextComponent text = TextUtil.literal(this.name);
        ITask.insert("task.chunk_pregen.name", this.getName(), text, TextFormatting.AQUA);
        ITask.insert("task.chunk_pregen.dimension", TextUtil.dimension(this.getDimension()), text, TextFormatting.GREEN);
        this.append(text);
        ITask.removeLast(text.func_150253_a());
        return TextUtil.translate("task.chunk_pregen.wrap", text);
    }

    protected abstract void append(ITextComponent var1);

    @Override
    public NBTTagCompound write() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("name", this.name);
        nbt.func_74768_a("dim", this.dimensionId);
        nbt.func_186854_a("taskId", this.task);
        nbt.func_74772_a("active_time", this.activeTime);
        return nbt;
    }

    @Override
    public void start() {
        DeleteProcessor.INSTANCE.startTask(this);
    }

    @Override
    public Future<DeleteProcess> createTask(PrepareProgress progress) {
        WorldServer world = DimensionManager.getWorld((int)this.getDimension());
        Path folder = this.getFolder();
        return ChunkPregenerator.SERVICE.submit(() -> this.createTask(world, folder, progress).setChunkHost(world));
    }

    protected Path getFolder() {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        String folder = DimensionManager.getProviderType((int)this.getDimension()).func_186070_d().getSaveFolder();
        return server.func_71254_M().func_186352_b(server.func_71270_I(), ".").toPath().resolve(folder == null ? "." : folder).resolve("region");
    }

    protected boolean isRegionFile(Path path) {
        return path.getFileName().toString().endsWith(".mca");
    }

    protected List<Path> getRegionFiles() {
        try {
            return ObjectIterators.pour(Files.newDirectoryStream(this.getFolder(), this::isRegionFile).iterator());
        }
        catch (IOException e) {
            return ObjectLists.emptyList();
        }
    }

    protected abstract DeleteProcess createTask(WorldServer var1, Path var2, PrepareProgress var3);
}

