/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.processor;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.DimensionType;
import net.minecraftforge.common.DimensionManager;
import pregenerator.impl.misc.Area;
import pregenerator.impl.processor.deleter.tasks.DeletionCircle;
import pregenerator.impl.processor.deleter.tasks.DeletionCircleArea;
import pregenerator.impl.processor.deleter.tasks.DeletionCircleExpansion;
import pregenerator.impl.processor.deleter.tasks.DeletionExcess;
import pregenerator.impl.processor.deleter.tasks.DeletionSpecific;
import pregenerator.impl.processor.deleter.tasks.DeletionSquare;
import pregenerator.impl.processor.deleter.tasks.DeletionSquareArea;
import pregenerator.impl.processor.deleter.tasks.DeletionSquareExpansion;
import pregenerator.impl.processor.deleter.tasks.DeletionTimeout;
import pregenerator.impl.processor.generator.tasks.BenchmarkTask;
import pregenerator.impl.processor.generator.tasks.CircleAreaTask;
import pregenerator.impl.processor.generator.tasks.CircleExpansionTask;
import pregenerator.impl.processor.generator.tasks.CircleTask;
import pregenerator.impl.processor.generator.tasks.SquareAreaTask;
import pregenerator.impl.processor.generator.tasks.SquareExpansionTask;
import pregenerator.impl.processor.generator.tasks.SquareTask;

public interface IBaseTask {
    public static final Int2ObjectMap<Function<NBTTagCompound, IBaseTask>> TASK_REGISTRY = new Int2ObjectOpenHashMap();

    public static void init() {
        TASK_REGISTRY.put(1, SquareTask::new);
        TASK_REGISTRY.put(2, CircleTask::new);
        TASK_REGISTRY.put(3, SquareExpansionTask::new);
        TASK_REGISTRY.put(4, CircleExpansionTask::new);
        TASK_REGISTRY.put(5, SquareAreaTask::new);
        TASK_REGISTRY.put(6, CircleAreaTask::new);
        TASK_REGISTRY.put(7, BenchmarkTask::new);
        TASK_REGISTRY.put(8, DeletionSquare::new);
        TASK_REGISTRY.put(9, DeletionCircle::new);
        TASK_REGISTRY.put(10, DeletionSquareExpansion::new);
        TASK_REGISTRY.put(11, DeletionCircleExpansion::new);
        TASK_REGISTRY.put(12, DeletionSquareArea::new);
        TASK_REGISTRY.put(13, DeletionCircleArea::new);
        TASK_REGISTRY.put(14, DeletionExcess::new);
        TASK_REGISTRY.put(15, DeletionTimeout::new);
        TASK_REGISTRY.put(16, DeletionSpecific::new);
    }

    public static IBaseTask loadTask(NBTTagCompound nbt) {
        Function creator = (Function)TASK_REGISTRY.get(nbt.func_74762_e("id"));
        return creator == null ? null : (IBaseTask)creator.apply(nbt);
    }

    public static NBTTagCompound saveTask(IBaseTask task) {
        if (task == null) {
            return null;
        }
        NBTTagCompound nbt = task.write();
        nbt.func_74774_a("id", task.getId());
        return nbt;
    }

    public byte getId();

    public String getName();

    public ITextComponent getShapeName();

    public ITextComponent getDescription();

    public UUID getTaskId();

    public Area getArea();

    public int getDimension();

    public long getTaskSize();

    public NBTTagCompound write();

    public void start();

    public long getActiveTime();

    public void addActiveTime(long var1);

    public static DimensionType getType(int type) {
        try {
            return DimensionManager.getProviderType((int)type);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

