/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.config;

import carbonconfiglib.config.ConfigEntry;
import carbonconfiglib.config.ConfigSection;
import pregenerator.base.api.Align;

public class PregenOverlay {
    ConfigEntry.BoolValue enabled;
    ConfigEntry.EnumValue<Align> HAlign;
    ConfigEntry.EnumValue<Align> VAlign;
    ConfigEntry.DoubleValue scale;
    ConfigEntry.IntValue pollDelay;

    public void init(ConfigSection section, boolean enabled, Align horizontal, Align vertical, double scale) {
        this.enabled = section.addBool("isEnabled", enabled, new String[]{"Defines if the Overlay is enabled"});
        this.HAlign = section.addEnum("Horizontal Alignment", (Enum)horizontal, Align.class, new String[]{"Defines the Horizontal Alignment of the Overlay"});
        this.VAlign = section.addEnum("Vertical Alignment", (Enum)vertical, Align.class, new String[]{"Defines the Vertical Alignment of the Overlay"});
        this.scale = section.addDouble("Scale", scale, new String[]{"Defines the scale of the Overlay"}).setRange(0.1, 100.0);
        this.pollDelay = section.addInt("Poll Delay", 1, new String[]{"Defines how many ticks between each poll are"}).setRange(1, 20);
    }

    public void setEnabled(boolean value) {
        this.enabled.set((Object)value);
    }

    public void setPollRate(int value) {
        this.pollDelay.set(Integer.valueOf(value));
    }

    public boolean isEnabled() {
        return this.enabled.get();
    }

    public Align vAlign() {
        return (Align)this.VAlign.get();
    }

    public Align hAlign() {
        return (Align)this.HAlign.get();
    }

    public double getScale() {
        return this.scale.get();
    }

    public int getPollDelay() {
        return Math.max(1, this.pollDelay.get());
    }
}

