/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.commands.base.args;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.command.CommandException;
import net.minecraft.command.NumberInvalidException;
import pregenerator.impl.commands.base.PregenCommands;
import pregenerator.impl.commands.base.args.IArgument;
import pregenerator.impl.commands.base.args.StringWalker;

public class TimeArgument
implements IArgument<Long> {
    private static final List<String> EXAMPLES = ObjectArrayList.wrap((Object[])new String[]{"1d", "1s", "1t", "1", "0"});
    private static final Map<Character, Long> TYPES = TimeArgument.createMultipliers();

    public static TimeArgument time() {
        return new TimeArgument();
    }

    @Override
    public Long parse(StringWalker args, PregenCommands.CommandContext context) throws CommandException {
        if (!args.canRead()) {
            throw new CommandException("commands.chunk_pregen.error.parse.missing.args", new Object[0]);
        }
        try {
            String s = args.peek();
            char multi = s.charAt(s.length() - 1);
            if (!TimeArgument.isNumber(multi)) {
                long result = (long)(Double.parseDouble(s.substring(0, s.length() - 2)) * TYPES.getOrDefault(Character.valueOf(multi), 1L).doubleValue());
                args.skip();
                return result;
            }
            return (long)args.readDouble();
        }
        catch (Exception e) {
            throw new NumberInvalidException("commands.chunk_pregen.error.parse.double", new Object[]{args.poll()});
        }
    }

    @Override
    public List<String> getExamples(PregenCommands.CommandContext context, int argumentIndex) {
        return EXAMPLES;
    }

    private static boolean isNumber(char character) {
        return character >= '0' && character <= '9' || character == '.' || character == '-';
    }

    private static Map<Character, Long> createMultipliers() {
        HashMap<Character, Long> data = new HashMap<Character, Long>();
        data.put(Character.valueOf('d'), 24000L);
        data.put(Character.valueOf('s'), 20L);
        data.put(Character.valueOf('t'), 1L);
        return data;
    }
}

