/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.commands.base.args;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.command.CommandException;
import pregenerator.impl.commands.base.PregenCommands;
import pregenerator.impl.commands.base.args.IArgument;
import pregenerator.impl.commands.base.args.StringWalker;
import pregenerator.impl.misc.FilePos;
import pregenerator.impl.structure.StructureManager;

public class StructureArgument
implements IArgument<FilePos> {
    public static final String DIMENSION_ARG = "dimension";
    public static final String TYPE_ARG = "type";
    public static final String POSITION_ARG = "position";
    private static final String TEMP_PREV_ARG = "structure_x";
    String argName;

    public static StructureArgument structures(String argName) {
        return new StructureArgument(argName);
    }

    public StructureArgument(String argName) {
        this.argName = argName;
    }

    @Override
    public FilePos parse(StringWalker args, PregenCommands.CommandContext context) throws CommandException {
        int x = args.readInt();
        try {
            int z = args.readInt();
            return new FilePos(x, z);
        }
        catch (CommandException e) {
            args.undo();
            context.addArgument(TEMP_PREV_ARG, x);
            throw e;
        }
    }

    @Override
    public List<String> getExamples(PregenCommands.CommandContext context, int argumentIndex) {
        if (argumentIndex == 0) {
            ArrayList<String> result = new ArrayList<String>();
            for (FilePos pos : this.getPositions(context)) {
                result.add(Integer.toString(pos.x));
            }
            return result;
        }
        Integer x = this.getXPosition(context);
        if (x == null) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        for (FilePos pos : this.getPositions(context)) {
            if (pos.x != x) continue;
            result.add(Integer.toString(pos.z));
        }
        return result;
    }

    @Override
    public int getArgumentElements() {
        return 2;
    }

    private Integer getXPosition(PregenCommands.CommandContext context) {
        if (context.hasArgument(TEMP_PREV_ARG, Integer.class)) {
            return context.getArgument(TEMP_PREV_ARG, Integer.class);
        }
        if (context.hasArgument(this.argName, FilePos.class)) {
            return context.getArgument((String)this.argName, FilePos.class).x;
        }
        return null;
    }

    private List<FilePos> getPositions(PregenCommands.CommandContext context) {
        if (!context.hasArgument(TYPE_ARG, String.class)) {
            return Collections.emptyList();
        }
        return StructureManager.INSTANCE.getStructurePositions(context.getArgumentOrDefault(DIMENSION_ARG, Integer.class, context.getSenderDimensionId()), context.getArgument(TYPE_ARG, String.class));
    }
}

