/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.commands.base.args;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.command.CommandException;
import pregenerator.base.api.TextUtil;
import pregenerator.impl.commands.base.PregenCommands;
import pregenerator.impl.commands.base.args.IArgument;
import pregenerator.impl.commands.base.args.StringWalker;

public class RangeArgument
implements IArgument<Integer> {
    public static final List<String> RADIUSES = ObjectArrayList.wrap((Object[])new String[]{"50", "100", "200", "300", "500", "1000", "4000", "10000", "25000", "800b", "1600b", "3200b", "4800b", "8000b", "16000b", "32000b", "64000b"});
    boolean isChunk;
    int min;
    int max;

    private RangeArgument(boolean isChunk, int min, int max) {
        this.isChunk = isChunk;
        this.min = min;
        this.max = max;
    }

    public static RangeArgument block() {
        return new RangeArgument(false, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public static RangeArgument blockMin(int min) {
        return new RangeArgument(false, min, Integer.MAX_VALUE);
    }

    public static RangeArgument blockMax(int max) {
        return new RangeArgument(false, Integer.MIN_VALUE, max);
    }

    public static RangeArgument blockRange(int min, int max) {
        return new RangeArgument(false, min, max);
    }

    public static RangeArgument chunk() {
        return new RangeArgument(true, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public static RangeArgument chunkMin(int min) {
        return new RangeArgument(true, min, Integer.MAX_VALUE);
    }

    public static RangeArgument chunkMax(int max) {
        return new RangeArgument(true, Integer.MIN_VALUE, max);
    }

    public static RangeArgument chunkRange(int min, int max) {
        return new RangeArgument(true, min, max);
    }

    @Override
    public Integer parse(StringWalker args, PregenCommands.CommandContext context) throws CommandException {
        int value = args.parseChunkOrBlock(this.isChunk);
        if (value < this.min) {
            throw new CommandException("commands.chunk_pregen.error.parse.to_small", new Object[]{TextUtil.NUMBERS.format(value), TextUtil.NUMBERS.format(this.min)});
        }
        if (value > this.max) {
            throw new CommandException("commands.chunk_pregen.error.parse.to_big", new Object[]{TextUtil.NUMBERS.format(value), TextUtil.NUMBERS.format(this.max)});
        }
        return value;
    }

    @Override
    public List<String> getExamples(PregenCommands.CommandContext context, int argumentIndex) {
        return RADIUSES;
    }
}

