/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.commands.base;

import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import pregenerator.impl.commands.base.ArgumentNode;
import pregenerator.impl.commands.base.LiteralNode;
import pregenerator.impl.commands.base.PregenCommand;
import pregenerator.impl.commands.base.PregenCommands;
import pregenerator.impl.commands.base.args.StringWalker;

public abstract class CommandNode {
    Map<String, CommandNode> children = new Object2ObjectOpenHashMap();
    Map<String, LiteralNode> literals = new Object2ObjectLinkedOpenHashMap();
    Map<String, ArgumentNode<?>> arguments = new Object2ObjectLinkedOpenHashMap();
    PregenCommand command;

    public abstract String getName();

    public abstract List<String> getExamples(PregenCommands.CommandContext var1, int var2);

    public Collection<CommandNode> getChildren() {
        return this.children.values();
    }

    public PregenCommand getCommand() {
        return this.command;
    }

    public List<String> getSuggestions(int argumentIndex, PregenCommands.CommandContext context) {
        ObjectArrayList possible = new ObjectArrayList();
        for (CommandNode node : this.children.values()) {
            possible.addAll(node.getExamples(context, argumentIndex));
        }
        return possible;
    }

    public CommandNode withCommand(PregenCommand command) {
        this.command = command;
        return this;
    }

    public void addChild(CommandNode node) {
        CommandNode child = this.children.get(node.getName());
        if (child != null) {
            if (node.command != null) {
                child.command = node.command;
            }
            node.getChildren().forEach(child::addChild);
            return;
        }
        this.children.put(node.getName(), node);
        if (node instanceof LiteralNode) {
            this.literals.put(node.getName(), (LiteralNode)node);
        }
        if (node instanceof ArgumentNode) {
            this.arguments.put(node.getName(), (ArgumentNode)node);
        }
    }

    public CommandNode findCurrentNode(StringWalker walker, PregenCommands.CommandContext context) {
        LiteralNode node;
        context.addNode(this);
        if (!walker.canRead()) {
            return this;
        }
        if (this.literals.size() > 0 && (node = this.literals.get(walker.peek())) != null) {
            walker.skip();
            return node.findCurrentNode(walker, context);
        }
        if (this.arguments.size() > 0) {
            for (ArgumentNode<?> node2 : this.arguments.values()) {
                StringWalker subWalker;
                if (node2.isValid(subWalker = walker.copy(), context)) {
                    walker.apply(subWalker);
                    return node2.findCurrentNode(walker, context);
                }
                int diff = subWalker.getIndex() - walker.getIndex();
                if (diff <= 0 || diff >= node2.getArgumentElements()) continue;
                walker.advance(diff);
                context.setArgumentIndex(diff);
                return this;
            }
        }
        return null;
    }

    public String toString() {
        return this.getName();
    }
}

