/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.commands;

import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraftforge.common.DimensionManager;
import pregenerator.base.api.TextUtil;
import pregenerator.impl.commands.base.CommandBuilder;
import pregenerator.impl.commands.base.CommandNode;
import pregenerator.impl.commands.base.PregenCommand;
import pregenerator.impl.commands.base.PregenCommands;
import pregenerator.impl.commands.base.args.BooleanArgument;
import pregenerator.impl.commands.base.args.DimensionArgument;
import pregenerator.impl.commands.base.args.IntegerArgument;
import pregenerator.impl.commands.base.args.PositionArgument;
import pregenerator.impl.commands.base.args.StringArgument;
import pregenerator.impl.commands.base.args.StructureArgument;
import pregenerator.impl.misc.FilePos;
import pregenerator.impl.misc.GenShape;
import pregenerator.impl.misc.SaveZone;
import pregenerator.impl.misc.Tuple;
import pregenerator.impl.structure.MapGenStructureDataPregen;
import pregenerator.impl.structure.StructureData;
import pregenerator.impl.structure.StructureManager;

public class StructureCommands {
    public static CommandNode createStructureCommands() {
        CommandBuilder builder = new CommandBuilder("structure");
        PregenCommand listStructures = StructureCommands::listStructures;
        builder.literal("list");
        builder.arg("dimension", DimensionArgument.any(), StructureCommands::dimensionSuggestions, listStructures);
        builder.arg("type", StringArgument.text(), StructureCommands::structureTypeSuggestions, listStructures).popTop();
        PregenCommand deleteStructure = StructureCommands::removeStructure;
        builder.literal("delete");
        builder.arg("dimension", DimensionArgument.any(), StructureCommands::dimensionSuggestions);
        builder.arg("type", StringArgument.text(), StructureCommands::structureTypeSuggestions);
        builder.arg("position", StructureArgument.structures("position"), deleteStructure);
        builder.arg("delete", BooleanArgument.bool(), deleteStructure).popTop();
        builder.literal("reset").arg("dimension", DimensionArgument.any(), StructureCommands::dimensionSuggestions, StructureCommands::resetStructures).popTop();
        CommandBuilder saveZone = new CommandBuilder("savezone");
        saveZone.literal("list").arg("dimension", DimensionArgument.any(), StructureCommands::listSaveZones).popTop();
        saveZone.literal("create");
        saveZone.arg("dimension", DimensionArgument.any());
        saveZone.arg("type", StringArgument.text(), StructureCommands::structureTypeSuggestions);
        saveZone.arg("id", StringArgument.text());
        saveZone.arg("center", PositionArgument.blockPos());
        saveZone.arg("radius", IntegerArgument.range(1, 30000000), StructureCommands::createSaveZone).popTop();
        saveZone.literal("remove");
        saveZone.arg("dimension", DimensionArgument.any());
        saveZone.arg("type", StringArgument.text(), StructureCommands::structureTypeSuggestions, listStructures);
        saveZone.arg("id", StringArgument.text(), StructureCommands::removeSaveZone).popTop();
        CommandNode result = builder.build();
        result.addChild(saveZone.build());
        return result;
    }

    private static void dimensionSuggestions(PregenCommands.CommandContext context, int argumentIndex, Consumer<String> suggestions) {
        StructureManager.INSTANCE.fetchDimensions(suggestions);
    }

    private static void structureTypeSuggestions(PregenCommands.CommandContext context, int argumentIndex, Consumer<String> suggestions) {
        StructureManager.INSTANCE.fetchTypes(context.getDimension("dimension"), suggestions);
    }

    private static void createSaveZone(PregenCommands.CommandContext context) {
        int dimension = context.getDimension("dimension");
        String type = context.getArgumentOrDefault("type", String.class, "All");
        String id = context.getArgument("id", String.class);
        FilePos center = context.getArgument("center", FilePos.class);
        int radius = context.getArgument("radius", Integer.class);
        if (!DimensionManager.isDimensionRegistered((int)dimension)) {
            context.sendFailure(TextUtil.dimensionMissing());
            return;
        }
        if (!StructureManager.INSTANCE.validateType(dimension, type)) {
            context.sendFailure(TextUtil.translate("commands.chunk_pregen.error.structure.type", type, TextUtil.dimension(dimension)));
            return;
        }
        if (StructureManager.INSTANCE.containsZone(type, dimension, id)) {
            context.sendFailure(TextUtil.translate("commands.chunk_pregen.error.savezone.existing", id));
            return;
        }
        StructureManager.INSTANCE.createSaveZone(type, dimension, new SaveZone(id, center.x, center.z, radius, radius));
        context.sendSuccess(TextUtil.translate("commands.chunk_pregen.savezone.created", id));
    }

    private static void listSaveZones(PregenCommands.CommandContext context) {
        int dimension = context.getDimension("dimension");
        String type = context.getArgumentOrDefault("type", String.class, "All");
        if (!DimensionManager.isDimensionRegistered((int)dimension)) {
            context.sendFailure(TextUtil.dimensionMissing());
            return;
        }
        if (!StructureManager.INSTANCE.validateType(dimension, type)) {
            context.sendFailure(TextUtil.translate("commands.chunk_pregen.error.structure.type", type, TextUtil.dimension(dimension)));
            return;
        }
        for (Map.Entry<String, List<SaveZone>> entry : StructureManager.INSTANCE.getBoxes(dimension).entrySet()) {
            List<SaveZone> list = entry.getValue();
            context.sendSuccess(TextUtil.translate("commands.chunk_pregen.savezone.list", TextUtil.NUMBERS.format(list.size()), entry.getKey()));
            for (SaveZone zone : list) {
                context.sendSuccess(zone.createCommand(dimension, type));
            }
        }
    }

    private static void removeSaveZone(PregenCommands.CommandContext context) {
        int dimension = context.getDimension("dimension");
        String type = context.getArgumentOrDefault("type", String.class, "All");
        String id = context.getArgument("id", String.class);
        if (!DimensionManager.isDimensionRegistered((int)dimension)) {
            context.sendFailure(TextUtil.dimensionMissing());
            return;
        }
        if (!StructureManager.INSTANCE.validateType(dimension, type)) {
            context.sendFailure(TextUtil.translate("commands.chunk_pregen.error.structure.type", type, TextUtil.dimension(dimension)));
            return;
        }
        if (StructureManager.INSTANCE.removeZone(type, dimension, id)) {
            context.sendFailure(TextUtil.translate("commands.chunk_pregen.error.savezone.missing", id));
            return;
        }
        context.sendSuccess(TextUtil.translate("commands.chunk_pregen.savezone.removed", id));
    }

    private static void listStructures(PregenCommands.CommandContext context) {
        int dimension = context.getDimension("dimension");
        String type = context.getArgumentOrDefault("type", String.class, "All");
        if (!DimensionManager.isDimensionRegistered((int)dimension)) {
            context.sendFailure(TextUtil.dimensionMissing());
            return;
        }
        if (!StructureManager.INSTANCE.validateType(dimension, type)) {
            context.sendFailure(TextUtil.translate("commands.chunk_pregen.error.structure.type", type, TextUtil.dimension(dimension)));
            return;
        }
        List<StructureData> data = StructureManager.INSTANCE.getStructures(dimension, type);
        context.sendSuccess(TextUtil.translate("commands.chunk_pregen.structure.found", TextUtil.NUMBERS.format(data.size())));
        for (StructureData entry : data) {
            context.sendSuccess(entry.createStructureMessage(dimension));
        }
    }

    private static void removeStructure(PregenCommands.CommandContext context) {
        int dimension = context.getDimension("dimension");
        String type = context.getArgument("type", String.class);
        FilePos position = context.getArgument("position", FilePos.class);
        boolean delete = context.getArgumentOrDefault("delete", Boolean.class, false);
        if (!DimensionManager.isDimensionRegistered((int)dimension)) {
            context.sendFailure(TextUtil.dimensionMissing());
            return;
        }
        if (!StructureManager.INSTANCE.validateType(dimension, type)) {
            context.sendFailure(TextUtil.translate("commands.chunk_pregen.error.structure.type", type, TextUtil.dimension(dimension)));
            return;
        }
        MapGenStructureDataPregen structure = StructureManager.INSTANCE.getStructure(dimension, type);
        if (structure == null) {
            context.sendFailure(TextUtil.translate("commands.chunk_pregen.error.structure.type", type, TextUtil.dimension(dimension)));
            return;
        }
        Tuple<FilePos, FilePos> targetArea = structure.deleteStructure(position);
        if (targetArea == null) {
            context.sendFailure(TextUtil.translate("commands.chunk_pregen.error.structure.missing", position.x, position.z));
            return;
        }
        context.sendSuccess(TextUtil.translate("commands.chunk_pregen.structure.deleted", position.x, position.z));
        if (delete) {
            context.sendSuccess(TextUtil.translate("commands.chunk_pregen.structure.task"));
            context.startTask(GenShape.SQUARE.createAreaDeleteTask("Structure_Removal_" + position.x + "_" + position.z, targetArea.getFirst(), targetArea.getSecond(), dimension));
        }
    }

    private static void resetStructures(PregenCommands.CommandContext context) {
        int dimension = context.getDimension("dimension");
        if (!DimensionManager.isDimensionRegistered((int)dimension)) {
            context.sendFailure(TextUtil.dimensionMissing());
            return;
        }
        StructureManager.INSTANCE.createSaveZone("All", dimension, new SaveZone("StructureReset", 0, 0, 60000000, 60000000));
        StructureManager.INSTANCE.removeZone("All", dimension, "StructureReset");
        context.sendSuccess(TextUtil.translate("commands.chunk_pregen.structure.reset"));
    }
}

