/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.commands;

import pregenerator.base.api.TextUtil;
import pregenerator.impl.commands.base.CommandBuilder;
import pregenerator.impl.commands.base.CommandNode;
import pregenerator.impl.commands.base.PregenCommands;
import pregenerator.impl.storage.GlobalListeners;
import pregenerator.impl.storage.PregenTaskStorage;
import pregenerator.impl.storage.ProcessListener;

public class InfoCommands {
    public static CommandNode createInfoCommands() {
        CommandBuilder builder = new CommandBuilder("info");
        builder.literal("listen", InfoCommands::listen).popTop();
        builder.literal("unlisten", InfoCommands::unlisten).popTop();
        builder.literal("autolisten", InfoCommands::autoListenState).literal("enable", InfoCommands::enableAuto).pop();
        builder.literal("disable", InfoCommands::disableAuto).pop();
        builder.literal("reset", InfoCommands::resetAuto).popTop();
        return builder.build();
    }

    private static void listen(PregenCommands.CommandContext context) {
        GlobalListeners.INSTANCE.addListener(ProcessListener.create(context.getSenderId()));
    }

    private static void unlisten(PregenCommands.CommandContext context) {
        GlobalListeners.INSTANCE.removeListener(ProcessListener.create(context.getSenderId()));
    }

    private static void enableAuto(PregenCommands.CommandContext context) {
        if (PregenTaskStorage.getStorage().add(context.getSenderId(), true)) {
            context.sendSuccess(TextUtil.translate("commands.chunk_pregen.info.listening.started", context.getSenderName()));
            return;
        }
        context.sendFailure(TextUtil.translate("commands.chunk_pregen.error.info.already.listen", context.getSenderName()));
    }

    private static void disableAuto(PregenCommands.CommandContext context) {
        if (PregenTaskStorage.getStorage().add(context.getSenderId(), false)) {
            context.sendSuccess(TextUtil.translate("commands.chunk_pregen.info.ignoring.started", context.getSenderName()));
            return;
        }
        context.sendFailure(TextUtil.translate("commands.chunk_pregen.error.info.already.ignore", context.getSenderName()));
    }

    private static void resetAuto(PregenCommands.CommandContext context) {
        PregenTaskStorage.getStorage().remove(context.getSenderId());
        context.sendSuccess(TextUtil.translate("commands.chunk_pregen.info.reset", context.getSenderName()));
    }

    private static void autoListenState(PregenCommands.CommandContext context) {
        switch (PregenTaskStorage.getStorage().getState(context.getSenderId())) {
            case 0: {
                context.sendSuccess(TextUtil.translate("commands.chunk_pregen.info.listening.state", context.getSenderName()));
                break;
            }
            case 1: {
                context.sendSuccess(TextUtil.translate("commands.chunk_pregen.info.ignoring.state", context.getSenderName()));
                break;
            }
            case 2: {
                context.sendSuccess(TextUtil.translate("commands.chunk_pregen.info.not_listening.state", context.getSenderName()));
            }
        }
    }
}

